/*
 * Decompiled with CFR 0.152.
 */
package org.mentawai.validation;

import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.mentawai.core.Action;
import org.mentawai.core.Input;
import org.mentawai.message.DefaultMessage;
import org.mentawai.message.Message;
import org.mentawai.message.MessageContext;
import org.mentawai.message.MessageManager;
import org.mentawai.rule.IntegerRule;
import org.mentawai.rule.RequiredRule;
import org.mentawai.rule.Rule;

public class Validator {
    public static String FIELD_TOKEN = "field";
    private Map<String, Object> rules;
    private Map<String, Object> errors;
    private Map<String, Object> params;

    public Validator(Map<String, Object> rules, Map<String, Object> errors) {
        this.rules = rules;
        this.errors = errors;
    }

    public Validator(Map<String, Object> rules, Map<String, Object> errors, Map<String, Object> params) {
        this(rules, errors);
        this.params = params;
    }

    private String getErrorId(String field, Rule rule) {
        Map map = (Map)this.errors.get(field);
        String id = (String)map.get(rule);
        return id;
    }

    private String[] getParams(String field, Rule rule) {
        if (this.params == null) {
            return null;
        }
        Map map = (Map)this.params.get(field);
        if (map != null) {
            return (String[])map.get(rule);
        }
        return null;
    }

    protected Map<String, String> getTokens(Action action, Map<String, String> tokens, String field) {
        String value;
        HashMap<String, String> map = new HashMap<String, String>();
        if (tokens != null) {
            for (String key : tokens.keySet()) {
                value = tokens.get(key);
                map.put(key, value);
            }
        }
        Input input = action.getInput();
        Iterator<String> iter = input.keys();
        while (iter.hasNext()) {
            String key = iter.next();
            String value2 = input.getString(key);
            map.put(key, value2);
        }
        value = input.getString(field);
        if (value != null) {
            map.put(FIELD_TOKEN, value);
        }
        return map;
    }

    public boolean validate(Action action, MessageContext msgContext) {
        boolean isOk = true;
        block0: for (String field : this.rules.keySet()) {
            List list = (List)this.rules.get(field);
            for (Rule rule : list) {
                String error_id = this.getErrorId(field, rule);
                if (rule.check(field, action)) continue;
                isOk = false;
                Map<String, Message> map = MessageManager.getFieldErrors(action, true);
                Map<String, String> tokens = this.getTokens(action, rule.getTokens(), field);
                String[] params = this.getParams(field, rule);
                map.put(field, new DefaultMessage(error_id, msgContext, tokens, params));
                continue block0;
            }
        }
        return isOk;
    }

    public void add(String field, Rule rule, String error_id) {
        LinkedList<Rule> list = (LinkedList<Rule>)this.rules.get(field);
        if (list == null) {
            list = new LinkedList<Rule>();
            this.rules.put(field, list);
        }
        list.add(rule);
        HashMap<Rule, String> map = (HashMap<Rule, String>)this.errors.get(field);
        if (map == null) {
            map = new HashMap<Rule, String>();
            this.errors.put(field, map);
        }
        map.put(rule, error_id);
    }

    public void requiredFields(String error_id, String ... fields) {
        if (fields == null || fields.length == 0) {
            return;
        }
        for (int i = 0; i < fields.length; ++i) {
            this.add(fields[i], (Rule)RequiredRule.getInstance(), error_id);
        }
    }

    public void requiredLists(String error_id, String ... fields) {
        if (fields == null || fields.length == 0) {
            return;
        }
        for (int i = 0; i < fields.length; ++i) {
            this.add(fields[i], (Rule)IntegerRule.getInstance(1), error_id);
        }
    }

    public void add(String field, Rule rule, String error_id, String ... params) {
        HashMap<Rule, String[]> map;
        this.add(field, rule, error_id);
        if (params == null || params.length == 0) {
            return;
        }
        if (this.params == null) {
            this.params = new HashMap<String, Object>();
        }
        if ((map = (HashMap<Rule, String[]>)this.params.get(field)) == null) {
            map = new HashMap<Rule, String[]>();
            this.params.put(field, map);
        }
        map.put(rule, params);
    }

    public void add(String field, Rule rule, int error_id) {
        this.add(field, rule, String.valueOf(error_id));
    }

    public void add(String field, Rule rule, int error_id, String ... params) {
        this.add(field, rule, String.valueOf(error_id), params);
    }
}

