/*
 * Decompiled with CFR 0.152.
 */
package org.mentawai.util;

public class RuntimeException
extends java.lang.RuntimeException {
    protected final Throwable rootCause;

    public RuntimeException() {
        this.rootCause = null;
    }

    public RuntimeException(String msg) {
        super(msg);
        this.rootCause = null;
    }

    public RuntimeException(Throwable t) {
        super(RuntimeException.getMsg(t), t);
        Throwable root = RuntimeException.getRootCause(t);
        this.setStackTrace(root.getStackTrace());
        this.rootCause = root == this ? null : root;
    }

    private static String getMsg(Throwable t) {
        Throwable root = RuntimeException.getRootCause(t);
        String msg = root.getMessage();
        if (!(msg != null && msg.length() != 0 || (msg = t.getMessage()) != null && msg.length() != 0)) {
            return root.getClass().getName();
        }
        return msg;
    }

    public RuntimeException(String msg, Throwable t) {
        this(msg, t, false);
    }

    public RuntimeException(String msg, Throwable t, boolean appendRootMsg) {
        super(RuntimeException.getMsg(msg, t, appendRootMsg), t);
        Throwable root = RuntimeException.getRootCause(t);
        this.setStackTrace(root.getStackTrace());
        this.rootCause = root == this ? null : root;
    }

    private static String getMsg(String msg, Throwable t, boolean append) {
        if (!append) {
            return msg;
        }
        StringBuilder sb = new StringBuilder(64);
        sb.append(msg);
        Throwable root = RuntimeException.getRootCause(t);
        String classname = root.getClass().getSimpleName();
        sb.append(" (").append(classname);
        String rootMsg = root.getMessage();
        if (rootMsg == null || rootMsg.length() == 0) {
            sb.append(")");
        } else {
            sb.append(": ").append(rootMsg).append(")");
        }
        return sb.toString();
    }

    private static Throwable getRootCause(Throwable t) {
        Throwable root = t.getCause();
        if (root == null) {
            return t;
        }
        while (root.getCause() != null) {
            root = root.getCause();
        }
        return root;
    }

    @Override
    public Throwable getCause() {
        return this.rootCause;
    }
}

