/*
 * Decompiled with CFR 0.152.
 */
package org.mentawai.util;

import java.lang.reflect.Method;
import java.util.Locale;
import org.mentawai.action.SuccessAction;
import org.mentawai.core.Action;
import org.mentawai.core.ActionException;
import org.mentawai.core.Context;
import org.mentawai.core.Input;
import org.mentawai.core.MapContext;
import org.mentawai.core.MapInput;
import org.mentawai.core.MapOutput;
import org.mentawai.core.Output;
import org.mentawai.util.RuntimeException;

public class MockAction
implements Action {
    private Action action;

    public MockAction(Action action) {
        this.action = action;
        MockAction.init(this);
    }

    public MockAction(Class<? extends Object> klass) {
        try {
            this.action = (Action)klass.newInstance();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        MockAction.init(this);
    }

    public MockAction() {
        this.action = new SuccessAction();
        MockAction.init(this);
    }

    public static <E> E getMockAction(Class<? extends E> klass) {
        try {
            E a = klass.newInstance();
            if (!(a instanceof Action)) {
                throw new InstantiationException("Class is not an Action: " + klass);
            }
            Action action = (Action)a;
            MockAction.init(action);
            return a;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static void init(Action action) {
        action.setInput(new MapInput());
        action.setOutput(new MapOutput());
        action.setSession(new MapContext());
        action.setApplication(new MapContext());
        action.setCookies(new MapContext());
        action.setLocale(Locale.getDefault());
    }

    public String execute() throws Exception {
        Method m = this.getMethod("execute");
        if (m != null) {
            try {
                return (String)m.invoke((Object)this.action, new Object[0]);
            }
            catch (Exception e) {
                throw new ActionException(e);
            }
        }
        throw new ActionException("The method execute cannot be found!");
    }

    public String callInnerAction(String innerAction) throws Exception {
        Method m = this.getMethod(innerAction);
        if (m != null) {
            try {
                return (String)m.invoke((Object)this.action, new Object[0]);
            }
            catch (Exception e) {
                throw new ActionException(e);
            }
        }
        throw new ActionException("The inner action does not exist: " + innerAction);
    }

    private Method getMethod(String innerAction) {
        try {
            Method m = this.action.getClass().getDeclaredMethod(innerAction, new Class[0]);
            if (m != null) {
                return m;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return null;
    }

    public Action getAction() {
        return this.action;
    }

    @Override
    public Context getApplication() {
        return this.action.getApplication();
    }

    @Override
    public void setApplication(Context application) {
        this.action.setApplication(application);
    }

    @Override
    public Input getInput() {
        return this.action.getInput();
    }

    @Override
    public void setInput(Input input) {
        this.action.setInput(input);
    }

    @Override
    public Locale getLocale() {
        return this.action.getLocale();
    }

    @Override
    public void setLocale(Locale locale) {
        this.action.setLocale(locale);
    }

    @Override
    public Output getOutput() {
        return this.action.getOutput();
    }

    @Override
    public void setOutput(Output output) {
        this.action.setOutput(output);
    }

    @Override
    public Context getSession() {
        return this.action.getSession();
    }

    @Override
    public void setSession(Context session) {
        this.action.setSession(session);
    }

    @Override
    public Context getCookies() {
        return this.action.getCookies();
    }

    @Override
    public void setCookies(Context context) {
        this.action.setCookies(context);
    }
}

