/*
 * Decompiled with CFR 0.152.
 */
package org.mentawai.util;

import java.net.URLEncoder;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletResponse;
import org.mentawai.util.RuntimeException;

public class HttpUtils {
    private static final String ENC = "UTF-8";

    public static void disableCache(HttpServletResponse res) {
        res.setHeader("Cache-Control", "no-cache");
        res.setHeader("Pragma", "no-cache");
        res.setDateHeader("Expires", 0L);
    }

    public static String encodeParam(String param) {
        try {
            return URLEncoder.encode(param, ENC);
        }
        catch (Throwable e) {
            throw new RuntimeException(e);
        }
    }

    public static String convertToQueryString(Map<String, Object> params) {
        return HttpUtils.convertToQueryString(params, null);
    }

    public static String convertToQueryString(Map<String, Object> params, String ... before) {
        char last;
        StringBuilder sb = new StringBuilder(1024);
        if (before != null) {
            for (String s : before) {
                sb.append(s);
            }
        }
        for (String key : params.keySet()) {
            Object value = params.get(key);
            if (value instanceof List) {
                List list = (List)value;
                for (Object o : list) {
                    sb.append(key).append('=');
                    sb.append(HttpUtils.encodeParam(o.toString()));
                    sb.append('&');
                }
                continue;
            }
            sb.append(key).append('=');
            sb.append(HttpUtils.encodeParam(value.toString()));
            sb.append('&');
        }
        if (sb.length() > 0 && (last = sb.charAt(sb.length() - 1)) == '&') {
            return sb.substring(0, sb.length() - 1);
        }
        return sb.toString();
    }
}

