/*
 * Decompiled with CFR 0.152.
 */
package org.mentawai.util;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;

public class Form {
    private final String name;
    private final Set<String> fields = new LinkedHashSet<String>();
    private final Map<String, Type> fieldsToTypes = new HashMap<String, Type>();
    private String[] fieldsArray = new String[0];
    private String[] fieldsBooleansArray = new String[0];
    private String[] fieldsListsArray = new String[0];
    private String[] fieldsDatesArray = new String[0];
    private final Set<String> requiredFields = new LinkedHashSet<String>();
    private String[] requiredFieldsArray = new String[0];
    private String[] requiredFieldsMinusBooleansArray = new String[0];
    private final Set<String> optionalFields = new LinkedHashSet<String>();
    private String[] optionalFieldsArray = new String[0];

    public Form(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public String toString() {
        return this.name;
    }

    public int hashCode() {
        return this.name.hashCode();
    }

    public boolean equals(Object obj) {
        if (obj instanceof Form) {
            Form f = (Form)obj;
            return f.name.equals(this.name);
        }
        return false;
    }

    public void addFields(String ... fields) {
        for (int i = 0; i < fields.length; ++i) {
            String field = fields[i];
            String name = this.getName(field);
            Type type = this.getType(field);
            this.fields.add(name);
            this.fieldsToTypes.put(name, type);
        }
        this.fieldsArray = this.getFieldsArray();
        this.fieldsBooleansArray = this.getFieldsBooleansArray();
        this.fieldsDatesArray = this.getFieldsDatesArray();
        this.fieldsListsArray = this.getFieldsListsArray();
    }

    public void addField(String field) {
        String name = this.getName(field);
        Type type = this.getType(field);
        this.fields.add(name);
        this.fieldsToTypes.put(name, type);
        this.fieldsArray = this.getFieldsArray();
        this.fieldsBooleansArray = this.getFieldsBooleansArray();
        this.fieldsDatesArray = this.getFieldsDatesArray();
        this.fieldsListsArray = this.getFieldsListsArray();
    }

    public boolean hasField(String field) {
        return this.fields.contains(field);
    }

    public int getNumberOfFields() {
        return this.fields.size();
    }

    public String[] getFields() {
        return this.fieldsArray;
    }

    public String[] getBooleanFields() {
        return this.fieldsBooleansArray;
    }

    public String[] getListFields() {
        return this.fieldsListsArray;
    }

    public String[] getDateFields() {
        return this.fieldsDatesArray;
    }

    private String[] getFieldsArray() {
        String[] s = new String[this.fields.size()];
        return this.fields.toArray(s);
    }

    private String[] getFieldsBooleansArray() {
        ArrayList<String> list = new ArrayList<String>(this.fieldsArray.length);
        for (int i = 0; i < this.fieldsArray.length; ++i) {
            String f = this.fieldsArray[i];
            Type t = this.fieldsToTypes.get(f);
            if (t != Type.BOOLEAN) continue;
            list.add(f);
        }
        String[] s = new String[list.size()];
        return list.toArray(s);
    }

    private String[] getFieldsListsArray() {
        ArrayList<String> list = new ArrayList<String>(this.fieldsArray.length);
        for (int i = 0; i < this.fieldsArray.length; ++i) {
            String f = this.fieldsArray[i];
            Type t = this.fieldsToTypes.get(f);
            if (t != Type.LIST) continue;
            list.add(f);
        }
        String[] s = new String[list.size()];
        return list.toArray(s);
    }

    private String[] getFieldsDatesArray() {
        ArrayList<String> list = new ArrayList<String>(this.fieldsArray.length);
        for (int i = 0; i < this.fieldsArray.length; ++i) {
            String f = this.fieldsArray[i];
            Type t = this.fieldsToTypes.get(f);
            if (t != Type.DATE) continue;
            list.add(f);
        }
        String[] s = new String[list.size()];
        return list.toArray(s);
    }

    private String[] diffArray(String[] a1, String[] a2) {
        LinkedHashSet<String> diff = new LinkedHashSet<String>();
        for (int i = 0; i < a1.length; ++i) {
            String s = a1[i];
            if (this.contains(s, a2)) continue;
            diff.add(s);
        }
        String[] array = new String[diff.size()];
        return diff.toArray(array);
    }

    private boolean contains(String s, String[] array) {
        for (int i = 0; i < array.length; ++i) {
            if (!s.equals(array[i])) continue;
            return true;
        }
        return false;
    }

    public void addRequiredFields(String ... fields) {
        this.addRequiredFields(false, fields);
    }

    public void addRequiredFields(boolean ignoreUnknownField, String ... fields) {
        if (this.optionalFields.size() > 0) {
            throw new IllegalStateException("This form already has optional fields! (" + this + ")");
        }
        for (int i = 0; i < fields.length; ++i) {
            if (!ignoreUnknownField && !this.hasField(fields[i])) {
                throw new IllegalArgumentException("Unknown field: " + fields[i] + "(" + this + ")");
            }
            this.requiredFields.add(fields[i]);
        }
        this.requiredFieldsArray = this.getRequiredFieldsArray();
        this.requiredFieldsMinusBooleansArray = this.getRequiredFieldsMinusBooleansArray();
        this.optionalFieldsArray = this.diffArray(this.fieldsArray, this.requiredFieldsArray);
    }

    public void addRequiredField(String field) {
        this.addRequiredField(false, field);
    }

    public void addRequiredField(boolean ignoreUnkownField, String field) {
        if (this.optionalFields.size() > 0) {
            throw new IllegalStateException("This form already has optional fields! (" + this + ")");
        }
        if (!ignoreUnkownField && !this.hasField(field)) {
            throw new IllegalArgumentException("Unknown field: " + field + "(" + this + ")");
        }
        this.requiredFields.add(field);
        this.requiredFieldsArray = this.getRequiredFieldsArray();
        this.requiredFieldsMinusBooleansArray = this.getRequiredFieldsMinusBooleansArray();
        this.optionalFieldsArray = this.diffArray(this.fieldsArray, this.requiredFieldsArray);
    }

    public boolean isRequired(String field) {
        return this.requiredFields.contains(field) || !this.optionalFields.contains(field);
    }

    public String[] getRequiredFields() {
        return this.requiredFieldsArray;
    }

    public String[] getRequiredFieldsMinusBooleans() {
        return this.requiredFieldsMinusBooleansArray;
    }

    private String[] getRequiredFieldsMinusBooleansArray() {
        LinkedHashSet<String> list = new LinkedHashSet<String>();
        for (int i = 0; i < this.requiredFieldsArray.length; ++i) {
            String field = this.requiredFieldsArray[i];
            Type type = this.fieldsToTypes.get(field);
            if (type == Type.BOOLEAN) continue;
            list.add(field);
        }
        String[] s = new String[list.size()];
        return list.toArray(s);
    }

    public int getNumberOfRequiredFields() {
        return this.requiredFieldsArray.length;
    }

    private String[] getRequiredFieldsArray() {
        String[] s = new String[this.requiredFields.size()];
        return this.requiredFields.toArray(s);
    }

    public void addOptionalFields(String ... fields) {
        this.addOptionalFields(false, fields);
    }

    public void addOptionalFields(boolean ignoreUnknownField, String ... fields) {
        if (this.requiredFields.size() > 0) {
            throw new IllegalStateException("This form already has required fields! (" + this + ")");
        }
        for (int i = 0; i < fields.length; ++i) {
            if (!ignoreUnknownField && !this.hasField(fields[i])) {
                throw new IllegalArgumentException("Unknown field: " + fields[i] + "(" + this + ")");
            }
            this.optionalFields.add(fields[i]);
        }
        this.optionalFieldsArray = this.getOptionalFieldsArray();
        this.requiredFieldsArray = this.diffArray(this.fieldsArray, this.optionalFieldsArray);
        this.requiredFieldsMinusBooleansArray = this.getRequiredFieldsMinusBooleansArray();
    }

    public void addOptionalField(String field) {
        this.addOptionalField(false, field);
    }

    public void addOptionalField(boolean ignoreUnknownField, String field) {
        if (this.requiredFields.size() > 0) {
            throw new IllegalStateException("This form already has required fields!");
        }
        if (!ignoreUnknownField && !this.hasField(field)) {
            throw new IllegalArgumentException("Unknown field: " + field);
        }
        this.optionalFields.add(field);
        this.optionalFieldsArray = this.getOptionalFieldsArray();
        this.requiredFieldsArray = this.diffArray(this.fieldsArray, this.optionalFieldsArray);
        this.requiredFieldsMinusBooleansArray = this.getRequiredFieldsMinusBooleansArray();
    }

    public boolean isOptional(String field) {
        return this.optionalFields.contains(field) || !this.requiredFields.contains(field);
    }

    public String[] getOptionalFields() {
        return this.optionalFieldsArray;
    }

    public int getNumberOfOptionalFields() {
        return this.optionalFieldsArray.length;
    }

    private String[] getOptionalFieldsArray() {
        String[] s = new String[this.optionalFields.size()];
        return this.optionalFields.toArray(s);
    }

    private Type getType(String s) {
        String[] array = s.split("\\:");
        if (array.length == 2) {
            String type = array[1].toUpperCase();
            try {
                return Type.valueOf(type);
            }
            catch (IllegalArgumentException e) {
                throw new IllegalArgumentException("Unkown type: " + type + " / " + this.name);
            }
        }
        throw new IllegalArgumentException("Invalid field name: " + s + " / " + this.name);
    }

    private String getName(String field) {
        String[] array = field.split("\\:");
        return array[0];
    }

    static enum Type {
        TEXT,
        LIST,
        BOOLEAN,
        DATE;

    }
}

