/*
 * Decompiled with CFR 0.152.
 */
package org.mentawai.util;

public class Exception
extends java.lang.Exception {
    protected final Throwable rootCause;

    public Exception() {
        this.rootCause = null;
    }

    public Exception(String msg) {
        super(msg);
        this.rootCause = null;
    }

    public Exception(Throwable t) {
        super(Exception.getMsg(t), t);
        Throwable root = Exception.getRootCause(t);
        this.setStackTrace(root.getStackTrace());
        this.rootCause = root == this ? null : root;
    }

    private static String getMsg(Throwable t) {
        Throwable root = Exception.getRootCause(t);
        String msg = root.getMessage();
        if (!(msg != null && msg.length() != 0 || (msg = t.getMessage()) != null && msg.length() != 0)) {
            return root.getClass().getName();
        }
        return msg;
    }

    public Exception(String msg, Throwable t) {
        this(msg, t, false);
    }

    public Exception(String msg, Throwable t, boolean appendRootMsg) {
        super(Exception.getMsg(msg, t, appendRootMsg), t);
        Throwable root = Exception.getRootCause(t);
        this.setStackTrace(root.getStackTrace());
        this.rootCause = root == this ? null : root;
    }

    private static String getMsg(String msg, Throwable t, boolean append) {
        if (!append) {
            return msg;
        }
        StringBuilder sb = new StringBuilder(64);
        sb.append(msg);
        Throwable root = Exception.getRootCause(t);
        String classname = root.getClass().getSimpleName();
        sb.append(" (").append(classname);
        String rootMsg = root.getMessage();
        if (rootMsg == null || rootMsg.length() == 0) {
            sb.append(")");
        } else {
            sb.append(": ").append(rootMsg).append(")");
        }
        return sb.toString();
    }

    private static Throwable getRootCause(Throwable t) {
        Throwable root = t.getCause();
        if (root == null) {
            return t;
        }
        while (root.getCause() != null) {
            root = root.getCause();
        }
        return root;
    }

    @Override
    public Throwable getCause() {
        return this.rootCause;
    }
}

