/*
 * Decompiled with CFR 0.152.
 */
package org.mentawai.util;

import java.util.Calendar;
import java.util.Date;
import java.util.Locale;

public final class DateUtils {
    public static Date onlyDate(Date date) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(date);
        cal.set(12, 0);
        cal.set(11, 0);
        cal.set(13, 0);
        cal.set(14, 0);
        return cal.getTime();
    }

    public static boolean isToday(Date date) {
        Date now = DateUtils.onlyDate(new Date());
        Date d = DateUtils.onlyDate(date);
        return now.equals(d);
    }

    public static long daysDiff(Date d1, Date d2) {
        long t1 = d1.getTime();
        long t2 = d2.getTime();
        return (t1 - t2) / 86400000L;
    }

    public static String getRelativeDate(Date date, Locale loc) {
        long delta = new Date().getTime() - date.getTime();
        if (delta < 5000L) {
            return "now";
        }
        if (delta < 60000L) {
            return DateUtils.toSeconds(delta) == 1L ? "one second ago" : DateUtils.toSeconds(delta) + " seconds ago";
        }
        if (delta < 120000L) {
            return "a minute ago";
        }
        if (delta < 2700000L) {
            return DateUtils.toMinutes(delta) + " minutes ago";
        }
        if (delta < 5400000L) {
            return "an hour ago";
        }
        if (delta < 86400000L) {
            return DateUtils.toHours(delta) + " hours ago";
        }
        if (delta < 172800000L) {
            return "yesterday";
        }
        if (delta < 2592000000L) {
            return DateUtils.toDays(delta) + " days ago";
        }
        if (delta < 29030400000L) {
            long months = DateUtils.toMonths(delta);
            return months <= 1L ? "one month ago" : months + " months ago";
        }
        long years = DateUtils.toYears(delta);
        return years <= 1L ? "one year ago" : years + " years ago";
    }

    private static long toSeconds(long date) {
        return date / 1000L;
    }

    private static long toMinutes(long date) {
        return DateUtils.toSeconds(date) / 60L;
    }

    private static long toHours(long date) {
        return DateUtils.toMinutes(date) / 60L;
    }

    private static long toDays(long date) {
        return DateUtils.toHours(date) / 24L;
    }

    private static long toMonths(long date) {
        return DateUtils.toDays(date) / 30L;
    }

    private static long toYears(long date) {
        return DateUtils.toMonths(date) / 365L;
    }
}

