/*
 * Decompiled with CFR 0.152.
 */
package org.mentawai.util;

import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;

public class AgeCalculator {
    public static int calculate(int year, int month, int day) {
        if (month < 1 || month > 12) {
            throw new IllegalArgumentException("Invalid month: " + month);
        }
        if (day < 1 || day > 31) {
            throw new IllegalArgumentException("Invalid day: " + day);
        }
        Calendar cd = Calendar.getInstance();
        GregorianCalendar bd = new GregorianCalendar(year, --month, day);
        bd.setLenient(false);
        int ageYears = cd.get(1) - bd.get(1);
        ageYears = cd.before(new GregorianCalendar(cd.get(1), month, day)) ? --ageYears : cd.get(1) - bd.get(1);
        return ageYears;
    }

    public static int calculate(Calendar cd) {
        return AgeCalculator.calculate(cd.get(1), cd.get(2) + 1, cd.get(5));
    }

    public static int calculate(Date birth) {
        Calendar cd = GregorianCalendar.getInstance();
        cd.setTime(birth);
        return AgeCalculator.calculate(cd);
    }

    public static void main(String[] args) {
        System.out.println("AGE: " + AgeCalculator.calculate(1976, 4, 30));
    }
}

