/*
 * Decompiled with CFR 0.152.
 */
package org.mentawai.transaction;

import javax.persistence.EntityManager;
import javax.persistence.EntityTransaction;
import org.mentawai.transaction.Transaction;

public class JpaTransaction
implements Transaction {
    private EntityManager session = null;
    private EntityTransaction transaction = null;
    private boolean active = false;

    public JpaTransaction() {
    }

    public JpaTransaction(EntityManager session) {
        this.session = session;
    }

    public JpaTransaction(EntityManager session, EntityTransaction transaction) {
        this(session);
        this.transaction = transaction;
    }

    public void setSession(EntityManager session) {
        this.session = session;
    }

    public void setTransaction(EntityTransaction transaction) {
        this.transaction = transaction;
    }

    @Override
    public void begin() throws Exception {
        if (this.session == null) {
            throw new IllegalStateException("HibernateTransaction does not have a hibernate session!");
        }
        if (this.transaction == null) {
            this.transaction = this.session.getTransaction();
        }
        this.active = true;
    }

    @Override
    public void commit() throws Exception {
        if (!this.active) {
            throw new IllegalStateException("Tried to commit but transaciton is not active!");
        }
        this.transaction.commit();
    }

    @Override
    public void rollback() throws Exception {
        if (!this.active) {
            throw new IllegalStateException("Tried to rollback but transaciton is not active!");
        }
        this.transaction.rollback();
    }

    @Override
    public boolean isActive() {
        return this.active;
    }

    @Override
    public void end() throws Exception {
        this.active = false;
    }

    public EntityManager getSession() {
        return this.session;
    }

    public EntityTransaction getTransaction() {
        return this.transaction;
    }
}

