/*
 * Decompiled with CFR 0.152.
 */
package org.mentawai.transaction;

import java.sql.Connection;
import org.mentawai.transaction.Transaction;

public class JdbcTransaction
implements Transaction {
    private boolean active = false;
    private Connection conn;
    private boolean oldAutoCommit;

    public JdbcTransaction() {
    }

    public JdbcTransaction(Connection conn) {
        this.conn = conn;
    }

    public void setConnection(Connection conn) {
        this.conn = conn;
    }

    public void setConn(Connection conn) {
        this.setConnection(conn);
    }

    public Connection getConn() {
        return this.conn;
    }

    public Connection getConnection() {
        return this.conn;
    }

    @Override
    public void begin() throws Exception {
        if (!this.active) {
            if (this.conn == null) {
                throw new IllegalStateException("JdbcTransaction does not have a connection!");
            }
            this.oldAutoCommit = this.conn.getAutoCommit();
            this.conn.setAutoCommit(false);
            this.active = true;
        }
    }

    @Override
    public void commit() throws Exception {
        if (!this.active) {
            throw new IllegalStateException("Tried to commit but transaciton is not active!");
        }
        this.conn.commit();
    }

    @Override
    public void rollback() throws Exception {
        if (!this.active) {
            throw new IllegalStateException("Tried to rollback but transaciton is not active!");
        }
        this.conn.rollback();
    }

    @Override
    public boolean isActive() {
        return this.active;
    }

    @Override
    public void end() throws Exception {
        if (this.conn != null) {
            this.conn.setAutoCommit(this.oldAutoCommit);
        }
        this.active = false;
    }
}

