/*
 * Decompiled with CFR 0.152.
 */
package org.mentawai.transaction;

import org.hibernate.Session;
import org.mentawai.transaction.Transaction;

public class HibernateTransaction
implements Transaction {
    private Session session = null;
    private org.hibernate.Transaction transaction = null;
    private boolean active = false;

    public HibernateTransaction() {
    }

    public HibernateTransaction(Session session) {
        this.session = session;
    }

    public HibernateTransaction(Session session, org.hibernate.Transaction transaction) {
        this(session);
        this.transaction = transaction;
        this.active = true;
    }

    public void setSession(Session session) {
        this.session = session;
    }

    public void setTransaction(org.hibernate.Transaction transaction) {
        this.transaction = transaction;
    }

    @Override
    public void begin() throws Exception {
        if (this.session == null) {
            throw new IllegalStateException("HibernateTransaction does not have a hibernate session!");
        }
        if (this.transaction == null) {
            this.transaction = this.session.beginTransaction();
        }
        this.active = true;
    }

    @Override
    public void commit() throws Exception {
        if (!this.active) {
            throw new IllegalStateException("Tried to commit but transaciton is not active!");
        }
        this.transaction.commit();
    }

    @Override
    public void rollback() throws Exception {
        if (!this.active) {
            throw new IllegalStateException("Tried to rollback but transaciton is not active!");
        }
        this.transaction.rollback();
    }

    @Override
    public boolean isActive() {
        return this.active;
    }

    @Override
    public void end() throws Exception {
        this.active = false;
    }

    public Session getSession() {
        return this.session;
    }

    public org.hibernate.Transaction getTransaction() {
        return this.transaction;
    }
}

