/*
 * Decompiled with CFR 0.152.
 */
package org.mentawai.tools;

import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.Date;

public class BeanConfig {
    private static void printFormat() {
        System.out.println("format: java org.mentawai.tools.BeanConfig <full-classname>");
    }

    public static void main(String[] args) throws Exception {
        if (args.length == 0) {
            BeanConfig.printFormat();
            return;
        }
        BeanConfig bc = new BeanConfig();
        bc.print(args[0]);
    }

    public void print(String className) throws Exception {
        Class<?> klass;
        try {
            klass = Class.forName(className);
        }
        catch (Exception e) {
            System.out.println("Error trying to resolve classname: " + className);
            e.printStackTrace();
            return;
        }
        Field[] fields = klass.getDeclaredFields();
        for (int i = 0; i < fields.length; ++i) {
            Field f = fields[i];
            if (Modifier.isStatic(f.getModifiers()) || Modifier.isFinal(f.getModifiers())) continue;
            Class<?> type = f.getType();
            String name = f.getName();
            System.out.println("\t.field(\"" + name + "\", \tDBTypes." + this.getDBType(type) + ")");
        }
    }

    protected String getDBType(Class<? extends Object> type) {
        if (type.equals(String.class)) {
            return "STRING";
        }
        if (type.equals(Integer.class) || type.equals(Integer.TYPE)) {
            return "INTEGER";
        }
        if (type.equals(Double.class) || type.equals(Double.TYPE)) {
            return "DOUBLE";
        }
        if (type.equals(Float.class) || type.equals(Float.TYPE)) {
            return "FLOAT";
        }
        if (type.equals(Long.class) || type.equals(Long.TYPE)) {
            return "LONG";
        }
        if (type.equals(java.sql.Date.class) || type.equals(Date.class)) {
            return "DATE";
        }
        if (type.equals(Boolean.class) || type.equals(Boolean.TYPE)) {
            return "BOOLEANINT";
        }
        return "????";
    }
}

