/*
 * Decompiled with CFR 0.152.
 */
package org.mentawai.template;

import java.io.IOException;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.mentawai.template.Page;
import org.mentawai.template.PageController;
import org.mentawai.template.TemplateException;
import org.mentawai.template.TemplateManager;

public abstract class TemplateServlet
extends HttpServlet {
    protected static final String TEMPLATE_MANAGER_ATTR = "TemplateManager";
    public static final String PAGE_ATTR = "Page";
    public static final String CURRENT_VIEW_ATTR = "_view";
    private static TemplateManager templateManager = null;

    public void init() throws ServletException {
        super.init();
        templateManager = this.createTemplateManager();
    }

    private TemplateManager createTemplateManager() {
        if (templateManager != null) {
            return templateManager;
        }
        try {
            Class<?> classTemplateManager;
            TemplateManager manager;
            String nameClassTemplateManager = this.getInitParameter(TEMPLATE_MANAGER_ATTR);
            if (nameClassTemplateManager == null || "".equals(nameClassTemplateManager)) {
                nameClassTemplateManager = TEMPLATE_MANAGER_ATTR;
            }
            if ((manager = (TemplateManager)(classTemplateManager = Class.forName(nameClassTemplateManager)).newInstance()) == null) {
                throw new TemplateException("TemplateManager not found");
            }
            manager.configurePages();
            return manager;
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new TemplateException(e);
        }
    }

    public static TemplateManager getTemplateManager() {
        return templateManager;
    }

    public static void setTemplateManager(TemplateManager manager) {
        templateManager = manager;
    }

    public static String extractPagePath(HttpServletRequest request) {
        String servletPath = request.getServletPath();
        return servletPath.substring(0, servletPath.lastIndexOf("."));
    }

    protected void processRequest(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        try {
            this.processTemplate(TemplateServlet.extractPagePath(request), this.createTemplateManager(), request, response, this.getServletContext());
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new TemplateException(e);
        }
    }

    public void processTemplate(String path, TemplateManager manager, HttpServletRequest request, HttpServletResponse response, ServletContext application) {
        Page page = manager.getPageForPath(path);
        if (page == null) {
            throw new TemplateException(path + " not found!");
        }
        String oldPath = page.getPath();
        page.setPath(path);
        try {
            this.putPageInResponse(page, request, response, application);
            TemplateServlet.executeListener(page, request, response, application);
            page.setPath(oldPath);
            if (!response.isCommitted()) {
                this.showPage(page, request, response, application);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new TemplateException(e);
        }
    }

    protected abstract void putPageInResponse(Page var1, HttpServletRequest var2, HttpServletResponse var3, ServletContext var4) throws Exception;

    protected abstract void showPage(Page var1, HttpServletRequest var2, HttpServletResponse var3, ServletContext var4) throws Exception;

    public static void executeListener(Page page, HttpServletRequest request, HttpServletResponse response, ServletContext application) throws Exception {
        if (page.getListener() != null) {
            PageController listener = (PageController)page.getListener().newInstance();
            listener.processPage(page, request, response, application);
        }
    }

    protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        this.processRequest(request, response);
    }

    protected void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        this.processRequest(request, response);
    }
}

