/*
 * Decompiled with CFR 0.152.
 */
package org.mentawai.template;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.mentawai.template.Page;
import org.mentawai.template.TemplateException;

public abstract class TemplateManager {
    private Map<String, Page> pages = new HashMap<String, Page>();

    public abstract void configurePages();

    public void add(Page page) {
        if (page.getPath() == null) {
            throw new TemplateException("Can't add a page without path");
        }
        String path = TemplateManager.cutSlash(page.getPath());
        if (this.findPageForPath(path, false) != null) {
            throw new TemplateException("Already exists a page with the path " + page.getPath());
        }
        this.pages.put(path, page);
    }

    public Collection<Page> getPages() {
        return this.pages.values();
    }

    public Page getPageForPath(String path) {
        Page page = this.findPageForPath(path = TemplateManager.cutSlash(path), false);
        if (page == null) {
            page = this.findPageForPath(path, true);
        }
        return page;
    }

    private Page findPageForPath(String path, boolean regexp) {
        if (!regexp) {
            return this.pages.get(path);
        }
        for (Page page : this.pages.values()) {
            if (!page.patternMatches(path)) continue;
            return page;
        }
        return null;
    }

    public void reconfigurePages() {
        this.pages.clear();
        this.configurePages();
    }

    private static String cutSlash(String name) {
        if (name.startsWith("/") && name.length() > 1) {
            return name.substring(1, name.length());
        }
        return name;
    }
}

