/*
 * Decompiled with CFR 0.152.
 */
package org.mentawai.template;

import java.util.HashMap;
import java.util.Map;
import java.util.regex.Pattern;

public class Page {
    private String path;
    private String view;
    private Map<String, Object> blocks = new HashMap<String, Object>();
    private Class listener;
    private Pattern pattern;

    public Page(String view) {
        this.view = view;
    }

    public Page(String path, String view) {
        this(view);
        this.path = path;
    }

    public Page(Page pageSuper) {
        this(pageSuper.getView());
        this.blocks.putAll(pageSuper.getBlocks());
        this.listener = pageSuper.getListener();
        this.pattern = pageSuper.getPattern();
    }

    public Page(String path, Page pageSuper) {
        this(pageSuper);
        this.path = path;
    }

    public Page(String view, Class listener) {
        this(view);
        this.listener = listener;
    }

    public Page(String path, String view, Class listener) {
        this(path, view);
        this.listener = listener;
        this.pattern = Pattern.compile(path);
    }

    public Page(Page pageSuper, Class listener) {
        this(pageSuper);
        this.listener = listener;
    }

    public Page(String path, Page pageSuper, Class listener) {
        this(path, pageSuper);
        this.listener = listener;
        this.pattern = pageSuper.getPattern();
    }

    public Map<String, Object> getBlocks() {
        return this.blocks;
    }

    public Page getBlock(String id) {
        return (Page)this.blocks.get(id);
    }

    public void setBlock(String id, Page page) {
        this.blocks.put(id, page);
    }

    public void setBlock(String id, String view) {
        this.setBlock(id, new Page(view));
    }

    public String getStringBlock(String id) {
        return this.blocks.get(id) + "";
    }

    public void setStringBlock(String id, String stringBlock) {
        this.blocks.put(id, stringBlock);
    }

    public String getPath() {
        return this.path;
    }

    public void setPath(String path) {
        this.path = path;
    }

    public void setView(String view) {
        this.view = view;
    }

    public String getView() {
        return this.view;
    }

    public Class getListener() {
        return this.listener;
    }

    public void setListener(Class listener) {
        this.listener = listener;
    }

    public Pattern getPattern() {
        return this.pattern;
    }

    public boolean patternMatches(String path) {
        return this.pattern == null ? false : this.pattern.matcher(path).matches();
    }
}

