/*
 * Decompiled with CFR 0.152.
 */
package org.mentawai.tag.util;

import java.io.IOException;
import java.lang.reflect.Method;
import java.util.Locale;
import java.util.Map;
import java.util.StringTokenizer;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import javax.servlet.jsp.JspException;
import javax.servlet.jsp.PageContext;
import javax.servlet.jsp.tagext.BodyContent;
import javax.servlet.jsp.tagext.BodyTagSupport;
import org.mentawai.action.BaseLoginAction;
import org.mentawai.core.Action;
import org.mentawai.core.Forward;
import org.mentawai.i18n.LocaleManager;
import org.mentawai.tag.Out;

public abstract class PrintTag
extends BodyTagSupport {
    protected ServletContext application = null;
    protected HttpSession session = null;
    protected HttpServletRequest req = null;
    protected HttpServletResponse res = null;
    protected Action action = null;
    protected Locale loc = null;
    protected int maxToPrint = -1;
    protected boolean noHTML = false;

    public void setMax(int maxToPrint) {
        this.maxToPrint = maxToPrint;
    }

    public void setNoHTML(boolean flag) {
        this.noHTML = flag;
    }

    public Object getValue(String value) {
        return this.getValue(value, false);
    }

    public Object getValue(String value, boolean tryBoolean) {
        return Out.getValue(value, this.pageContext, tryBoolean);
    }

    public Object getSessionObj() {
        return BaseLoginAction.getSessionObj(this.session);
    }

    public abstract String getStringToPrint() throws JspException;

    protected String getBody() {
        String s;
        BodyContent bc = this.getBodyContent();
        if (bc != null && (s = bc.getString()) != null && !(s = s.trim()).equals("")) {
            return s;
        }
        return null;
    }

    public static Boolean getBooleanValue(Object bean, String value) {
        Object obj;
        Method m;
        StringBuffer sb;
        try {
            sb = new StringBuffer(50);
            sb.append("is");
            sb.append(value.substring(0, 1).toUpperCase());
            if (value.length() > 1) {
                sb.append(value.substring(1));
            }
            if ((m = bean.getClass().getMethod(sb.toString(), new Class[0])) != null) {
                m.setAccessible(true);
                obj = m.invoke(bean, new Object[0]);
                if (obj instanceof Boolean) {
                    return (Boolean)obj;
                }
            }
        }
        catch (Exception e) {
            // empty catch block
        }
        try {
            sb = new StringBuffer(50);
            sb.append("has");
            sb.append(value.substring(0, 1).toUpperCase());
            if (value.length() > 1) {
                sb.append(value.substring(1));
            }
            if ((m = bean.getClass().getMethod(sb.toString(), new Class[0])) != null && (obj = m.invoke(bean, new Object[0])) instanceof Boolean) {
                return (Boolean)obj;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }

    public static Object getValue(Object bean, String name, boolean tryBoolean) {
        Method m;
        StringBuffer sb;
        try {
            sb = new StringBuffer(50);
            sb.append("get");
            sb.append(name.substring(0, 1).toUpperCase());
            if (name.length() > 1) {
                sb.append(name.substring(1));
            }
            if ((m = bean.getClass().getMethod(sb.toString(), new Class[0])) != null) {
                m.setAccessible(true);
                return m.invoke(bean, new Object[0]);
            }
        }
        catch (Exception e) {
            // empty catch block
        }
        if (name.equals("size")) {
            try {
                sb = new StringBuffer(50);
                sb.append(name);
                m = bean.getClass().getMethod(sb.toString(), new Class[0]);
                if (m != null) {
                    m.setAccessible(true);
                    return m.invoke(bean, new Object[0]);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (tryBoolean) {
            return PrintTag.getBooleanValue(bean, name);
        }
        return null;
    }

    public static Object getValue(String expression, PageContext pageContext, boolean tryBoolean) {
        StringTokenizer st = new StringTokenizer(expression, ".");
        if (st.countTokens() == 1) {
            return pageContext.findAttribute(st.nextToken());
        }
        if (st.countTokens() > 1) {
            String first = st.nextToken();
            Object value = pageContext.findAttribute(first);
            if (value == null) {
                return null;
            }
            while (st.hasMoreTokens()) {
                String next = st.nextToken();
                if (value instanceof Map && !next.equals("size")) {
                    Map map = (Map)value;
                    value = map.get(next);
                } else {
                    value = PrintTag.getValue(value, next, tryBoolean);
                }
                if (value != null) continue;
                return null;
            }
            return value;
        }
        return null;
    }

    public static Object getValue(String expression, Object bean, boolean tryBoolean) {
        StringTokenizer st = new StringTokenizer(expression, ".");
        if (st.countTokens() == 1) {
            return PrintTag.getValue(bean, st.nextToken(), tryBoolean);
        }
        String first = st.nextToken();
        Object value = PrintTag.getValue(bean, first, false);
        if (value == null) {
            return null;
        }
        while (st.hasMoreTokens()) {
            String next = st.nextToken();
            if (value instanceof Map) {
                Map map = (Map)value;
                value = map.get(next);
            } else {
                value = PrintTag.getValue(value, next, tryBoolean && !st.hasMoreTokens());
            }
            if (value != null) continue;
            return null;
        }
        return value;
    }

    public int doStartTag() throws JspException {
        this.application = this.pageContext.getServletContext();
        this.session = this.pageContext.getSession();
        this.req = (HttpServletRequest)this.pageContext.getRequest();
        this.res = (HttpServletResponse)this.pageContext.getResponse();
        this.action = (Action)this.req.getAttribute(Forward.ACTION_REQUEST);
        this.loc = LocaleManager.getLocale(this.req);
        return super.doStartTag();
    }

    public int doEndTag() throws JspException {
        String s = this.getStringToPrint();
        if (s != null) {
            if (this.noHTML) {
                s = s.replaceAll("\\<.*?\\>", "");
            }
            if (this.maxToPrint > 0 && s.length() > this.maxToPrint) {
                s = s.substring(0, this.maxToPrint) + "...";
            }
            try {
                this.pageContext.getOut().print(s);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        return 6;
    }
}

