/*
 * Decompiled with CFR 0.152.
 */
package org.mentawai.tag.util;

import java.io.IOException;
import javax.servlet.jsp.JspException;
import org.mentaregex.Regex;
import org.mentawai.tag.util.PrintTag;

public abstract class PrintBodyTag
extends PrintTag {
    private boolean replaceAll = false;

    public void setReplaceAll(boolean flag) {
        this.replaceAll = flag;
    }

    @Override
    public int doEndTag() throws JspException {
        String s = this.getStringToPrint();
        String body = this.getBody();
        if (body != null) {
            if (s.contains("/")) {
                s = s.replaceAll("/", "#/");
            }
            s = this.replaceAll ? Regex.sub(body, "s/#$#{out#}/" + s + "/g", '#') : Regex.sub(body, "s/#$#{out#}/" + s + "/", '#');
        }
        if (s != null) {
            if (this.noHTML) {
                s = s.replaceAll("\\<.*?\\>", "");
            }
            if (this.maxToPrint > 0 && s.length() > this.maxToPrint) {
                s = s.substring(0, this.maxToPrint) + "...";
            }
            try {
                this.pageContext.getOut().print(s);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        return 6;
    }
}

