/*
 * Decompiled with CFR 0.152.
 */
package org.mentawai.tag.util;

import java.lang.reflect.Method;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.List;

public class ListSorter
implements Comparator<Object> {
    private String campo;

    public ListSorter(String campo) {
        if (campo == null || campo.isEmpty()) {
            throw new IllegalArgumentException("Invalid property for ordenate: \"" + campo + "\"");
        }
        this.campo = campo;
    }

    @Override
    public int compare(Object first, Object second) {
        if (this.campo.contains(".")) {
            String[] fields = this.campo.split("\\.");
            Object firstValueSwap = first;
            Object secondValueSwap = second;
            for (int i = 0; i < fields.length; ++i) {
                if (firstValueSwap != null) {
                    firstValueSwap = this.getValue(firstValueSwap, fields[i]);
                }
                if (secondValueSwap == null) continue;
                secondValueSwap = this.getValue(secondValueSwap, fields[i]);
            }
            return this.compareBy(firstValueSwap, secondValueSwap);
        }
        return this.compareBy(this.getValue(first, this.campo), this.getValue(second, this.campo));
    }

    private Object getValue(Object obj, String field) {
        Method getMethod = null;
        if (obj instanceof Collection) {
            Collection c = (Collection)obj;
            if (c.isEmpty()) {
                return null;
            }
            obj = c.iterator().next();
        }
        try {
            getMethod = obj.getClass().getMethod("get".concat(field.substring(0, 1).toUpperCase()).concat(field.substring(1)), null);
        }
        catch (Exception e) {
            throw new IllegalStateException(e + " for ordenate.");
        }
        try {
            obj = getMethod.invoke(obj, (Object[])null);
        }
        catch (Exception e) {
            obj = null;
        }
        return obj;
    }

    public int compareBy(Object primeiro, Object segundo) {
        if (primeiro == null) {
            return -1;
        }
        if (segundo == null) {
            return 1;
        }
        if (primeiro == null && segundo == null) {
            return 0;
        }
        if (primeiro == null) {
            return -1;
        }
        if (segundo == null) {
            return 1;
        }
        if (primeiro instanceof Number) {
            return new Double(String.valueOf(primeiro)).compareTo(new Double(String.valueOf(segundo)));
        }
        if (primeiro instanceof Date) {
            return ((Date)primeiro).compareTo((Date)segundo);
        }
        if (primeiro instanceof String) {
            try {
                Double d = Double.parseDouble(String.valueOf(primeiro));
                return d.compareTo(new Double(String.valueOf(segundo)));
            }
            catch (Exception e) {
                return String.valueOf(primeiro).compareToIgnoreCase(String.valueOf(segundo));
            }
        }
        return -1;
    }

    public static List<Object> sort(List<Object> lista, String campo, boolean reverse) {
        if (lista != null && !lista.isEmpty() && campo != null && campo.trim().length() != 0) {
            ListSorter o = new ListSorter(campo);
            Collections.sort(lista, o);
            if (reverse) {
                Collections.reverse(lista);
            }
        }
        return lista;
    }
}

