/*
 * Decompiled with CFR 0.152.
 */
package org.mentawai.tag.util;

import java.io.IOException;
import java.io.Writer;
import java.util.Locale;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import javax.servlet.jsp.JspException;
import javax.servlet.jsp.tagext.BodyContent;
import javax.servlet.jsp.tagext.BodyTagSupport;
import org.mentaregex.Regex;
import org.mentawai.action.BaseLoginAction;
import org.mentawai.core.Action;
import org.mentawai.core.Forward;
import org.mentawai.i18n.LocaleManager;
import org.mentawai.tag.Out;

public abstract class ConditionalWithElseTag
extends BodyTagSupport {
    private static final String ELSE_REGEX = "\\s*\\[else\\]\\s*";
    private String else_regex = "\\s*\\[else\\]\\s*";
    private boolean negate = false;
    protected ServletContext application = null;
    protected HttpSession session = null;
    protected HttpServletRequest req = null;
    protected HttpServletResponse res = null;
    protected Action action = null;
    protected Locale loc = null;

    public void setElseMarker(String elseMarker) {
        this.else_regex = "\\s*\\[" + elseMarker + "\\]\\s*";
    }

    public void setNegate(boolean negate) {
        this.negate = negate;
    }

    public abstract boolean testCondition() throws JspException;

    public Object getValue(String value) {
        return this.getValue(value, false);
    }

    public Object getValue(String value, boolean tryBoolean) {
        return Out.getValue(value, this.pageContext, tryBoolean);
    }

    public Object getSessionObj() {
        return BaseLoginAction.getSessionObj(this.session);
    }

    public int doStartTag() throws JspException {
        this.application = this.pageContext.getServletContext();
        this.session = this.pageContext.getSession();
        this.req = (HttpServletRequest)this.pageContext.getRequest();
        this.res = (HttpServletResponse)this.pageContext.getResponse();
        this.action = (Action)this.req.getAttribute(Forward.ACTION_REQUEST);
        this.loc = LocaleManager.getLocale(this.req);
        return 2;
    }

    private String getBody() {
        String s;
        BodyContent bc = this.getBodyContent();
        if (bc != null && (s = bc.getString()) != null && !(s = s.trim()).equals("")) {
            return s;
        }
        return null;
    }

    public int doAfterBody() throws JspException {
        String body = this.getBody();
        String finalBody = null;
        if (body != null && Regex.matches(body, "/" + this.else_regex + "/")) {
            String[] blocks = body.split(this.else_regex);
            if (blocks.length != 2) {
                throw new JspException("Invalid body! [ELSE] found more than once!");
            }
            finalBody = this.testCondition() ? (!this.negate ? blocks[0] : blocks[1]) : (!this.negate ? blocks[1] : blocks[0]);
        } else {
            finalBody = this.testCondition() ? (!this.negate ? body : "") : (!this.negate ? "" : body);
        }
        BodyContent bc = this.getBodyContent();
        try {
            if (bc != null) {
                if (finalBody != null) {
                    bc.getEnclosingWriter().print(finalBody);
                } else {
                    bc.writeOut((Writer)bc.getEnclosingWriter());
                }
            }
        }
        catch (IOException e) {
            throw new JspException((Throwable)e);
        }
        finally {
            if (bc != null) {
                bc.clearBody();
            }
        }
        return 0;
    }
}

