/*
 * Decompiled with CFR 0.152.
 */
package org.mentawai.tag.util;

import java.io.IOException;
import java.io.Writer;
import java.util.Locale;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import javax.servlet.jsp.JspException;
import javax.servlet.jsp.tagext.BodyContent;
import javax.servlet.jsp.tagext.BodyTagSupport;
import org.mentawai.core.Action;
import org.mentawai.core.Forward;
import org.mentawai.i18n.LocaleManager;
import org.mentawai.tag.util.Context;

public abstract class AbstractContext
extends BodyTagSupport
implements Context {
    protected ServletContext application = null;
    protected HttpSession session = null;
    protected HttpServletRequest req = null;
    protected HttpServletResponse res = null;
    protected Locale loc = null;
    protected Action action = null;
    protected String var = null;

    public void setVar(String var) {
        this.var = var;
    }

    private String getVar() {
        if (this.var == null) {
            return this.getName();
        }
        return this.var;
    }

    protected abstract String getName();

    public int doStartTag() throws JspException {
        this.application = this.pageContext.getServletContext();
        this.session = this.pageContext.getSession();
        this.req = (HttpServletRequest)this.pageContext.getRequest();
        this.res = (HttpServletResponse)this.pageContext.getResponse();
        this.loc = LocaleManager.getLocale(this.req);
        this.action = (Action)this.req.getAttribute(Forward.ACTION_REQUEST);
        Object object = this.getObject();
        if (object != null) {
            this.pageContext.setAttribute(this.getVar(), object, 1);
        }
        return super.doStartTag();
    }

    public int doAfterBody() throws JspException {
        BodyContent bc = this.getBodyContent();
        try {
            if (bc != null) {
                bc.writeOut((Writer)bc.getEnclosingWriter());
            }
        }
        catch (IOException e) {
            throw new JspException((Throwable)e);
        }
        finally {
            if (bc != null) {
                bc.clearBody();
            }
        }
        return 0;
    }

    public int doEndTag() throws JspException {
        this.pageContext.removeAttribute(this.getVar(), 1);
        return super.doEndTag();
    }
}

