/*
 * Decompiled with CFR 0.152.
 */
package org.mentawai.tag.paginator;

import java.io.IOException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.servlet.jsp.JspException;
import javax.servlet.jsp.tagext.BodyContent;
import javax.servlet.jsp.tagext.BodyTagSupport;
import javax.servlet.jsp.tagext.Tag;
import org.mentawai.tag.Out;
import org.mentawai.tag.util.ListContext;

public class PaginatorTag
extends BodyTagSupport
implements ListContext {
    public static final String DEFAULT_PAGENUM_PARAM = "page";
    public static final int DEFAULT_MAX_PER_PAGE = 10;
    private int maxPerPage = 10;
    private String pageNumParam = "page";
    private int currPage = 0;
    private List<Object> list = null;
    private String value = null;

    public void setValue(String value) {
        this.value = value;
    }

    public void setSize(int size) {
        this.maxPerPage = size;
    }

    public void setPageNumParam(String pageNumParam) {
        this.pageNumParam = pageNumParam;
    }

    public int getCurrPage() {
        return this.currPage;
    }

    public int getTotal() {
        return this.list != null ? this.list.size() : 0;
    }

    public int getFrom() {
        int currPage = this.getCurrPage();
        return (currPage - 1) * this.maxPerPage + 1;
    }

    public int getTo() {
        int currPage = this.getCurrPage();
        boolean hasNextPage = this.hasNextPage();
        if (hasNextPage) {
            return currPage * this.maxPerPage;
        }
        return this.list.size();
    }

    public int getLastPage() {
        int total = this.list.size();
        int last = total / this.maxPerPage;
        if (total % this.maxPerPage != 0) {
            ++last;
        }
        return last;
    }

    public boolean hasNextPage() {
        int high = (this.currPage - 1) * this.maxPerPage + this.maxPerPage;
        return high < this.list.size();
    }

    public boolean hasPreviousPage() {
        return this.currPage - 1 != 0;
    }

    @Override
    public List<Object> getList() {
        if (this.list.size() == 0) {
            return this.list;
        }
        int low = (this.currPage - 1) * this.maxPerPage;
        int high = low + this.maxPerPage;
        if (low >= this.list.size()) {
            throw new IllegalStateException("LOW = " + low + " and LIST = " + this.list.size());
        }
        if (high > this.list.size()) {
            high = this.list.size();
        }
        int size = high - low;
        ArrayList<Object> retlist = new ArrayList<Object>(size);
        for (int i = 0; i < size; ++i) {
            retlist.add(this.list.get(low + i));
        }
        return retlist;
    }

    public int doStartTag() throws JspException {
        Object o;
        Tag parent = PaginatorTag.findAncestorWithClass((Tag)this, ListContext.class);
        if (parent != null) {
            ListContext ctx = (ListContext)parent;
            this.list = ctx.getList();
        } else {
            o = Out.getValue(this.value, this.pageContext, false);
            if (o instanceof List) {
                this.list = (List)o;
            } else if (o instanceof Collection) {
                Collection c = (Collection)o;
                this.list = new ArrayList<Object>(c.size());
                for (Object obj : c) {
                    this.list.add(obj);
                }
            }
        }
        o = this.pageContext.getRequest().getParameter(this.pageNumParam);
        if (o == null) {
            o = this.pageContext.findAttribute(this.pageNumParam);
        }
        String page = null;
        if (o != null) {
            page = o.toString();
        }
        this.currPage = page == null ? 1 : Integer.parseInt(page);
        if (this.list == null) {
            return 0;
        }
        return 2;
    }

    public int doAfterBody() throws JspException {
        BodyContent bc = this.getBodyContent();
        try {
            if (bc != null) {
                bc.writeOut((Writer)bc.getEnclosingWriter());
            }
        }
        catch (IOException e) {
            throw new JspException((Throwable)e);
        }
        finally {
            if (bc != null) {
                bc.clearBody();
            }
            this.list = null;
        }
        return 0;
    }
}

