/*
 * Decompiled with CFR 0.152.
 */
package org.mentawai.tag.paginator;

import javax.servlet.jsp.JspException;
import javax.servlet.jsp.tagext.Tag;
import org.mentawai.tag.paginator.PaginatorTag;
import org.mentawai.tag.util.Context;
import org.mentawai.tag.util.LoopTag;

public class PageNumbers
extends LoopTag
implements Context {
    private int pagesToShow = 5;
    private String var = "pageNum";
    private int startPageNum;
    private int endPageNum;
    private int currPage;
    private PaginatorTag paginator = null;

    public void setPagesToShow(int pagesToShow) {
        this.pagesToShow = pagesToShow;
    }

    public void setVar(String var) {
        this.var = var;
    }

    @Override
    public Object getObject() throws JspException {
        return this.pageContext.getAttribute(this.var);
    }

    public int getCurrPage() {
        return this.currPage;
    }

    @Override
    public void init() throws JspException {
        Tag parent = PageNumbers.findAncestorWithClass((Tag)this, PaginatorTag.class);
        if (parent == null) {
            throw new JspException("PageNumbers not enclosed by a PaginatorTag !!!");
        }
        this.paginator = (PaginatorTag)parent;
        int currPageNum = this.paginator.getCurrPage();
        this.startPageNum = currPageNum - this.pagesToShow;
        if (this.startPageNum < 1) {
            this.startPageNum = 1;
        }
        this.endPageNum = currPageNum + this.pagesToShow;
        int lastPage = this.paginator.getLastPage();
        if (this.endPageNum > lastPage) {
            this.endPageNum = lastPage;
        }
        this.currPage = this.startPageNum;
    }

    @Override
    public boolean loopCondition() throws JspException {
        if (this.currPage > this.endPageNum) {
            return false;
        }
        if (this.startPageNum == this.endPageNum) {
            return false;
        }
        this.pageContext.setAttribute(this.var, (Object)new Integer(this.currPage));
        return true;
    }

    @Override
    public void afterEachLoop() throws JspException {
        ++this.currPage;
    }

    public int doEndTag() throws JspException {
        this.pageContext.removeAttribute(this.var);
        return super.doEndTag();
    }
}

