/*
 * Decompiled with CFR 0.152.
 */
package org.mentawai.tag.i18n;

import java.util.Locale;
import javax.servlet.jsp.JspException;
import javax.servlet.jsp.tagext.Tag;
import org.mentaregex.Regex;
import org.mentawai.i18n.I18N;
import org.mentawai.i18n.LocaleManager;
import org.mentawai.tag.Out;
import org.mentawai.tag.util.Context;
import org.mentawai.tag.util.PrintTag;

public class PrintI18N
extends PrintTag {
    private static boolean DEBUG = LocaleManager.I18N_DEBUG;
    private String key;
    private String[] dynValues = null;
    private boolean noPrefix = false;

    public void setKey(String key) {
        this.key = key.trim();
    }

    public void setNoPrefix(boolean noPrefix) {
        this.noPrefix = noPrefix;
    }

    public void setDynValues(String dynValues) {
        this.dynValues = dynValues.split("\\s*,\\s*");
    }

    protected String getKey() throws JspException {
        if (this.key != null) {
            return this.key;
        }
        String body = this.getBody();
        if (body != null) {
            return body;
        }
        throw new JspException("i18n tag does not have key attribute and does not have body text!");
    }

    @Override
    public String getStringToPrint() throws JspException {
        String key = this.getKey();
        boolean hasKey = this.key != null;
        String body = this.getBody();
        I18N[] props = (I18N[])this.pageContext.getAttribute("_i18n");
        Locale loc = (Locale)this.pageContext.getAttribute("_locale");
        String prefix = (String)this.pageContext.getAttribute("_prefix");
        if (prefix != null && !this.noPrefix) {
            key = prefix + "." + key;
        }
        if (props == null || loc == null) {
            throw new JspException("i18n tag needs a useI18N tag in the same page!");
        }
        for (int i = props.length - 1; i >= 0; --i) {
            if (props[i] == null || !props[i].hasKey(key)) continue;
            String v = props[i].get(key);
            String cp = this.req.getContextPath();
            if (cp.startsWith("/")) {
                cp = "#" + cp;
            }
            v = Regex.sub(v, "s/<mtw:contextPath *#/>/" + cp + "/g", '#');
            if (this.dynValues != null) {
                Tag parent = PrintI18N.findAncestorWithClass((Tag)this, Context.class);
                int index = 0;
                for (String dynValue : this.dynValues) {
                    Object dynVal = Out.getValue(parent, dynValue, this.pageContext, true);
                    String dynValString = dynVal != null ? dynVal.toString() : "NULL";
                    v = Regex.sub(v, "s/#$" + ++index + "/" + dynValString + "/g", '#');
                }
            }
            if (DEBUG) {
                return "{" + v + "}";
            }
            return v;
        }
        if (hasKey && body != null && DEBUG) {
            StringBuilder sb = new StringBuilder(128);
            sb.append(key).append(" = ").append(body);
            return sb.toString();
        }
        StringBuilder sb = new StringBuilder(128);
        sb.append('!');
        sb.append(loc.toString());
        sb.append('.');
        sb.append(key);
        sb.append('!');
        return sb.toString();
    }
}

