/*
 * Decompiled with CFR 0.152.
 */
package org.mentawai.tag.html.dyntag.inputText;

import javax.servlet.jsp.JspException;
import javax.servlet.jsp.tagext.Tag;
import javax.servlet.jsp.tagext.TagAdapter;
import org.mentawai.tag.html.ajax.InPlaceTag;
import org.mentawai.tag.html.dyntag.BaseTag;

public class InputText
extends BaseTag {
    private static final long serialVersionUID = 1L;
    private static final String SEPARATOR = "#";
    private String extra;
    private String separator = "#";
    private String maxlength = null;
    private String size = null;
    private String readonly = null;

    public boolean isInPlaceTagIntegration() {
        Tag parent = this.getParent();
        if (parent != null) {
            InPlaceTag ipt = null;
            try {
                ipt = (InPlaceTag)((TagAdapter)parent).getAdaptee();
            }
            catch (ClassCastException e) {
                return false;
            }
            ipt.setType("text");
            if (this.getName() != null) {
                ipt.setName(this.getName());
            }
            if (this.getSize() != null) {
                ipt.setSize(Short.valueOf(this.getSize()));
            }
            if (this.getKlass() != null) {
                ipt.setKlass(this.getKlass());
            }
            if (this.getKlassStyle() != null) {
                ipt.setStyle(this.getKlassStyle());
            }
            if (this.getMaxlength() != null) {
                ipt.setMaxlength(this.getMaxlength());
            }
            if (this.getValue() != null) {
                ipt.setValue(this.getValue());
            }
            return true;
        }
        return false;
    }

    protected StringBuffer buildTag() {
        StringBuffer results = new StringBuffer("<input");
        this.prepareAttribute(results, "type", "text");
        this.prepareAttribute(results, "name", this.getName());
        this.prepareAttribute(results, "class", this.getKlass());
        this.prepareAttribute(results, "style", "text-align:" + this.getTextAlign() + ";" + this.getKlassStyle());
        this.prepareAttribute(results, "size", this.getSize());
        this.prepareAttribute(results, "maxlength", this.getMaxlength());
        if (this.getDisabled() != null && this.getDisabled().equals("true")) {
            results.append(" disabled=\"disabled\"");
        }
        if (this.getReadonly() != null && this.getReadonly().equals("true")) {
            results.append(" readonly=\"readonly\"");
        }
        if (this.getId() == null || this.getId().trim().equals("")) {
            this.setId(this.getName());
        }
        this.prepareAttribute(results, "id", this.getId());
        this.prepareAttribute(results, "title", this.getTitle());
        this.prepareValue(results);
        results.append(this.prepareEventHandlers());
        results.append(this.getExtraAttributes());
        return results;
    }

    protected void prepareValue(StringBuffer results) {
        Object value = this.findObject(this.getName());
        if (value != null) {
            results.append(" value=\"").append(value).append("\"");
        } else if (this.getValue() != null) {
            results.append(" value=\"").append(this.getValue()).append("\"");
        }
    }

    protected String prepareEventHandlers() {
        StringBuffer handlers = new StringBuffer();
        this.prepareMouseEvents(handlers);
        this.prepareKeyEvents(handlers);
        this.prepareTextEvents(handlers);
        this.prepareFocusEvents(handlers);
        return handlers.toString();
    }

    @Override
    public String getStringToPrint() throws JspException {
        if (this.isInPlaceTagIntegration()) {
            return "";
        }
        StringBuffer results = new StringBuffer(200);
        results.append(this.buildTag().toString());
        results.append(this.getTagClose());
        return results.toString();
    }

    @Override
    protected String getExtraAttributes() {
        if (this.extra == null) {
            return "";
        }
        StringBuffer sb = new StringBuffer(512);
        String[] s = this.extra.split("\\" + this.separator);
        for (int i = 0; i < s.length; ++i) {
            String[] ss = s[i].split("=");
            if (ss.length != 2) continue;
            sb.append(" ").append(ss[0].trim()).append("=\"").append(ss[1].trim()).append('\"');
        }
        return sb.toString();
    }

    public String getMaxlength() {
        return this.maxlength;
    }

    public void setMaxlength(String maxlength) {
        this.maxlength = maxlength;
    }

    public String getSize() {
        return this.size;
    }

    public void setSize(String size) {
        this.size = size;
    }

    public String getReadonly() {
        return this.readonly;
    }

    public void setReadonly(String readonly) {
        this.readonly = readonly;
    }

    @Override
    public void setExtra(String extra) {
        this.extra = extra;
    }

    @Override
    public void setSeparator(String separator) {
        this.separator = separator;
    }
}

