/*
 * Decompiled with CFR 0.152.
 */
package org.mentawai.tag.html.dyntag.inputMoney;

import java.math.BigDecimal;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.util.Locale;
import javax.servlet.jsp.JspException;
import javax.servlet.jsp.tagext.Tag;
import javax.servlet.jsp.tagext.TagAdapter;
import net.sf.json.JSONObject;
import org.mentawai.tag.html.ajax.InPlaceTag;
import org.mentawai.tag.html.dyntag.inputText.InputText;

public class InputMoney
extends InputText {
    private static final long serialVersionUID = 1L;
    private int decimals = 2;
    private String dec_point = ",";
    private String thousands_sep = ".";

    @Override
    public boolean isInPlaceTagIntegration() {
        Tag parent = this.getParent();
        if (parent != null) {
            InPlaceTag ipt = null;
            try {
                ipt = (InPlaceTag)((TagAdapter)parent).getAdaptee();
            }
            catch (ClassCastException e) {
                return false;
            }
            JSONObject options = new JSONObject();
            options.put((Object)"par1", (Object)this.decimals);
            options.put((Object)"par2", (Object)this.thousands_sep);
            options.put((Object)"par3", (Object)this.dec_point);
            ipt.setMaskerOptions(options);
            ipt.setTypeMask((byte)1);
            if (this.getValue() != null) {
                ipt.setValue(this.customizeMask(this.getDecimals(), this.getThousands_sep(), this.getDec_point(), this.getValue()));
            }
            ipt.setType("text");
            if (this.getName() != null) {
                ipt.setName(this.getName());
            }
            if (this.getSize() != null) {
                ipt.setSize(Short.valueOf(this.getSize()));
            }
            if (this.getKlass() != null) {
                ipt.setKlass(this.getKlass());
            }
            if (this.getKlassStyle() != null) {
                ipt.setStyle(this.getKlassStyle());
            }
            if (this.getMaxlength() != null) {
                ipt.setMaxlength(this.getMaxlength());
            }
            return true;
        }
        return false;
    }

    @Override
    public StringBuffer buildTag() {
        if (this.isInPlaceTagIntegration()) {
            return new StringBuffer(1);
        }
        StringBuffer results = new StringBuffer(super.buildTag().toString());
        results.append(this.getTagClose());
        results.append("\n");
        results.append("\t\t<script type=\"text/javascript\">");
        results.append("inputMoneyMask(document.getElementById(\"" + this.getId() + "\")," + this.getDecimals() + ",\"" + this.getThousands_sep() + "\",\"" + this.getDec_point() + "\")");
        results.append("</script>");
        return results;
    }

    @Override
    protected void prepareValue(StringBuffer results) {
        Object value = this.findObject(this.getName());
        if (value != null) {
            results.append(" value=\"").append(this.customizeMask(this.getDecimals(), this.getThousands_sep(), this.getDec_point(), value)).append("\"");
        } else if (this.getValue() != null) {
            results.append(" value=\"").append(this.customizeMask(this.getDecimals(), this.getThousands_sep(), this.getDec_point(), this.getValue())).append("\"");
        }
    }

    protected String makeZeros(int dec) {
        StringBuilder sb = new StringBuilder(dec);
        for (int i = 0; i < dec; ++i) {
            sb.append("0");
        }
        return sb.toString();
    }

    protected String formatNumber(Object object, int decimals, String decimal) {
        if ((double)new Float(object.toString()).floatValue() == 0.0) {
            return "0." + this.makeZeros(decimals);
        }
        if (object instanceof Float) {
            return new DecimalFormat("#,##0." + this.makeZeros(decimals), new DecimalFormatSymbols(new Locale("en", "US"))).format((Float)object);
        }
        if (object instanceof String) {
            return new DecimalFormat("#,##0." + this.makeZeros(decimals), new DecimalFormatSymbols(new Locale("en", "US"))).format(new Float(object.toString()));
        }
        if (object instanceof Double) {
            return new DecimalFormat("#,##0." + this.makeZeros(decimals), new DecimalFormatSymbols(new Locale("en", "US"))).format(new Double(object.toString()));
        }
        if (object instanceof BigDecimal) {
            return new DecimalFormat("#,##0." + this.makeZeros(decimals), new DecimalFormatSymbols(new Locale("en", "US"))).format((BigDecimal)object);
        }
        return object.toString();
    }

    protected String customizeMask(int decimals, String thousands, String decimal, Object number) {
        Float f = this.convert(number);
        if (f == null) {
            return number.toString();
        }
        String fmtNumber = this.formatNumber(f, decimals, decimal);
        if (!thousands.equals(",")) {
            fmtNumber = fmtNumber.replace(',', 'T');
        }
        if (!decimal.equals(".")) {
            fmtNumber = fmtNumber.replace('.', 'D');
        }
        fmtNumber = fmtNumber.replace('T', thousands.charAt(0));
        fmtNumber = fmtNumber.replace('D', decimal.charAt(0));
        return fmtNumber;
    }

    public Float convert(Object numero) {
        if (numero == null) {
            return null;
        }
        String s = numero.toString().trim();
        try {
            Float f = new Float(s);
            return f;
        }
        catch (NumberFormatException e) {
            if (s.indexOf(",") > 0) {
                s = s.replace(".", "");
                s = s.replace(",", ".");
            }
            try {
                Float f = new Float(s);
                return f;
            }
            catch (NumberFormatException e2) {
                return null;
            }
        }
    }

    @Override
    public String getStringToPrint() throws JspException {
        StringBuffer results = new StringBuffer(200);
        results.append(this.buildTag().toString());
        return results.toString();
    }

    public String getDec_point() {
        return this.dec_point;
    }

    public void setDec_point(String dec_point) {
        this.dec_point = dec_point;
    }

    public int getDecimals() {
        return this.decimals;
    }

    public void setDecimals(int decimals) {
        this.decimals = decimals;
    }

    public String getThousands_sep() {
        return this.thousands_sep;
    }

    public void setThousands_sep(String thousands_sep) {
        this.thousands_sep = thousands_sep;
    }
}

