/*
 * Decompiled with CFR 0.152.
 */
package org.mentawai.tag.html.dyntag.inputDate;

import java.text.SimpleDateFormat;
import java.util.Date;
import javax.servlet.jsp.JspException;
import javax.servlet.jsp.tagext.Tag;
import javax.servlet.jsp.tagext.TagAdapter;
import net.sf.json.JSONObject;
import org.mentawai.formatter.Formatter;
import org.mentawai.formatter.FormatterManager;
import org.mentawai.tag.html.ajax.InPlaceTag;
import org.mentawai.tag.html.dyntag.inputDate.listener.InputDateListener;
import org.mentawai.tag.html.dyntag.inputText.InputText;

public class InputDate
extends InputText {
    private static final long serialVersionUID = 1L;
    private String dateFormat = "dd/mm/yyyy";
    private String titleButton = null;

    public String getDateFormat() {
        return this.dateFormat;
    }

    public void setDateFormat(String dateFormat) {
        this.dateFormat = dateFormat;
    }

    public String getTitleButton() {
        return this.titleButton;
    }

    public void setTitleButton(String titleButton) {
        this.titleButton = titleButton;
    }

    @Override
    public boolean isInPlaceTagIntegration() {
        Tag parent = this.getParent();
        if (parent != null) {
            InPlaceTag ipt = null;
            try {
                ipt = (InPlaceTag)((TagAdapter)parent).getAdaptee();
            }
            catch (ClassCastException e) {
                return false;
            }
            JSONObject options = new JSONObject();
            options.put((Object)"par1", (Object)this.getDateFormat().replaceAll("[dmy]", "9"));
            options.put((Object)"par2", (Object)this.getDateFormat().replaceFirst("yyyy", "y"));
            ipt.setMaskerOptions(options);
            ipt.setTypeMask((byte)2);
            StringBuffer sb = new StringBuffer(20);
            this.prepareValue(sb);
            String[] splited = sb.toString().split("=");
            if (splited.length == 2) {
                ipt.setValue(splited[1].replaceAll("\"", ""));
            }
            ipt.setType("text");
            if (this.getName() != null) {
                ipt.setName(this.getName());
            }
            if (this.getSize() != null) {
                ipt.setSize(Short.valueOf(this.getSize()));
            }
            if (this.getKlass() != null) {
                ipt.setKlass(this.getKlass());
            }
            if (this.getKlassStyle() != null) {
                ipt.setStyle(this.getKlassStyle());
            }
            if (this.getMaxlength() != null) {
                ipt.setMaxlength(this.getMaxlength());
            }
            return true;
        }
        return false;
    }

    @Override
    public StringBuffer buildTag() {
        if (this.isInPlaceTagIntegration()) {
            return new StringBuffer(1);
        }
        StringBuffer results = new StringBuffer(super.buildTag().toString());
        this.prepareAttribute(results, "maxlenght", String.valueOf(this.getDateFormat().length()));
        results.append(this.getTagClose());
        results.append("&nbsp;");
        results.append("<img");
        this.prepareAttribute(results, "id", this.getName() + "-button");
        this.prepareAttribute(results, "align", "absmiddle");
        this.prepareAttribute(results, "height", "16");
        this.prepareAttribute(results, "width", "16");
        this.prepareAttribute(results, "style", "cursor:pointer");
        this.prepareAttribute(results, "src", this.req.getContextPath() + InputDateListener.IMG_COMPONTENT);
        this.prepareAttribute(results, "title", this.getTitleButton());
        this.prepareValue(results);
        results.append(this.getTagClose());
        results.append("\n");
        results.append("\t\t<script type=\"text/javascript\">");
        results.append("Calendar.setup({");
        results.append("inputField: \"" + this.getId() + "\",");
        results.append("button: \"" + this.getName() + "-button" + "\",");
        results.append("ifFormat: \"" + InputDate.getNewFormat(this.getDateFormat()) + "\",");
        results.append("align: \"Tr\"");
        results.append("});");
        results.append("</script>");
        results.append("\n");
        results.append("\t\t<script type=\"text/javascript\">");
        results.append("inputDateMask(document.getElementById(\"" + this.getId() + "\"),\"" + this.getDateFormat().replaceAll("[dmy]", "9") + "\");");
        results.append("</script>");
        return results;
    }

    @Override
    protected void prepareValue(StringBuffer results) {
        Object value = this.findObject(this.getName());
        if (value != null) {
            if (value instanceof Date) {
                Formatter f = FormatterManager.getFixedDateFormatter();
                SimpleDateFormat formatter = new SimpleDateFormat(this.getDateFormat().replace('m', 'M'));
                Date date = (Date)value;
                if (f == null) {
                    results.append(" value=\"").append(formatter.format(date)).append("\"");
                } else {
                    results.append(" value=\"").append(f.format(date, this.loc)).append("\"");
                }
            } else {
                results.append(" value=\"").append(value).append("\"");
            }
        } else if (this.getValue() != null) {
            results.append(" value=\"").append(this.getValue()).append("\"");
        }
    }

    @Override
    public String getStringToPrint() throws JspException {
        StringBuffer results = new StringBuffer(200);
        results.append(this.buildTag().toString());
        return results.toString();
    }

    public static String getNewFormat(String currentFormat) {
        String newFormat = currentFormat;
        if (currentFormat.trim().equals("dd/mm/yyyy")) {
            newFormat = newFormat.replace("yyyy", "yY");
        } else if (currentFormat.trim().equals("mm/dd/yyyy")) {
            newFormat = newFormat.replace("yyyy", "yY");
        }
        newFormat = newFormat.replaceFirst("d", "%");
        newFormat = newFormat.replaceFirst("m", "%");
        newFormat = newFormat.replaceFirst("y", "%");
        return newFormat;
    }
}

