/*
 * Decompiled with CFR 0.152.
 */
package org.mentawai.tag.html.ajax;

import javax.servlet.jsp.JspException;
import org.mentawai.i18n.I18N;
import org.mentawai.tag.html.dyntag.BaseTag;

public class AjaxSelect
extends BaseTag {
    private static final long serialVersionUID = 1L;
    private String sourceValue = null;
    private String url = null;
    private String functionName = null;
    private boolean emptyField = false;
    private String emptyFieldValue = null;
    private String defEmptyFieldValue = null;
    private String swapValue = null;
    private String keyValue = null;
    private boolean useLoadingMessage = true;

    private StringBuffer buildTag() {
        String[] values = this.findValues(this.getName(), false, true);
        if (this.getId() == null || this.getId().trim().equals("")) {
            this.setId(this.getName());
        }
        StringBuffer sb = new StringBuffer();
        sb.append("<select ");
        this.prepareAttribute(sb, "name", this.getName());
        this.prepareAttribute(sb, "id", this.getId());
        this.prepareAttribute(sb, "onchange", this.getOnchange());
        this.prepareAttribute(sb, "class", this.getKlass());
        this.prepareAttribute(sb, "style", this.getKlassStyle());
        sb.append(this.getExtraAttributes());
        sb.append(">\n");
        this.buildDefaultValue(sb);
        sb.append("</select>\n");
        sb.append("<script type=\"text/javascript\">");
        sb.append("\nfunction " + this.functionName + "() {\n");
        sb.append("\tvar r = new mtw.request();\n");
        sb.append("\tr.addParameter(\"sourceValue\", mtw.util.getValue(\"" + this.sourceValue + "\") );\n");
        sb.append("\tr.setUrl(\"" + this.url + "\");\n");
        sb.append("\tr.onSuccess(\n");
        sb.append("\t\tfunction (trans){\n");
        sb.append("\t\t\tvar rq = new mtw.response(trans);\n");
        sb.append("\t\t\tmtw.removeOptions(\"" + this.getId() + "\");\n");
        if (this.emptyField) {
            sb.append("\t\t\tmtw.addOptions(\"" + this.getId() + "\", rq, '" + this.keyValue + "', '" + this.swapValue + "');\n");
        } else {
            sb.append("\t\t\tmtw.addOptions(\"" + this.getId() + "\", rq);\n");
        }
        this.whenValidating(sb, values);
        sb.append("\t\t}\n");
        sb.append("\t);\n");
        if (this.useLoadingMessage) {
            sb.append("\tr.useLoadingMessage();\n");
        }
        sb.append("\tr.send();\n");
        sb.append("}\n");
        if (values != null && values.length > 0) {
            sb.append("Event.observe(window, 'load', function() {\n");
            sb.append("\t" + this.functionName + "();\n");
            sb.append("});\n");
        }
        sb.append("</script>\n\n");
        return sb;
    }

    private void buildDefaultValue(StringBuffer sb) {
        this.keyValue = this.defEmptyFieldValue;
        if (this.defEmptyFieldValue == null) {
            this.keyValue = "";
        }
        if (this.emptyField) {
            if (this.emptyFieldValue != null) {
                String value = null;
                if (this.emptyFieldValue.length() >= 3 && this.emptyFieldValue.startsWith("!") && this.emptyFieldValue.endsWith("!")) {
                    I18N[] props = (I18N[])this.pageContext.getAttribute("_i18n");
                    String prefix = (String)this.pageContext.getAttribute("_prefix");
                    if (props != null) {
                        String key = this.emptyFieldValue.substring(1, this.emptyFieldValue.length() - 1);
                        if (prefix != null) {
                            String prefixKey = prefix + "." + key;
                            for (int i = props.length - 1; i >= 0; --i) {
                                if (props[i] == null || !props[i].hasKey(prefixKey)) continue;
                                value = props[i].get(prefixKey);
                                break;
                            }
                        }
                        if (value == null) {
                            for (int i = props.length - 1; i >= 0; --i) {
                                if (props[i] == null || !props[i].hasKey(key)) continue;
                                value = props[i].get(key);
                                break;
                            }
                        }
                    }
                }
                if (value != null) {
                    sb.append("<option value=\"" + this.keyValue + "\">").append(value).append("</option>\n");
                    this.swapValue = value;
                } else {
                    sb.append("<option value=\"" + this.keyValue + "\">").append(this.emptyFieldValue).append("</option>\n");
                    this.swapValue = this.emptyFieldValue;
                }
            } else {
                sb.append("<option value=\"" + this.keyValue + "\"> - </option>\n");
                this.swapValue = " - ";
            }
        }
    }

    private void whenValidating(StringBuffer sb, String[] values) {
        if (values != null && values.length > 0) {
            sb.append("\t\t\tvar arr = new Array();\n");
            for (int i = 0; i < values.length; ++i) {
                sb.append("\t\t\tarr[" + i + "] = \"" + values[i].toString() + "\";\n");
            }
            sb.append("\t\t\tmtw.util.setValue(\"" + this.getId() + "\", arr);\n");
        }
    }

    @Override
    public String getStringToPrint() throws JspException {
        if (this.sourceValue == null) {
            throw new JspException("sourceValue cannot be null!");
        }
        StringBuffer result = new StringBuffer();
        result.append(this.buildTag().toString());
        this.setId(null);
        return result.toString();
    }

    protected String prepareEventHandlers() {
        StringBuffer handlers = new StringBuffer();
        this.prepareMouseEvents(handlers);
        this.prepareKeyEvents(handlers);
        this.prepareTextEvents(handlers);
        this.prepareFocusEvents(handlers);
        return handlers.toString();
    }

    public void setFunctionName(String functionName) {
        this.functionName = functionName;
    }

    public void setSourceValue(String source) {
        this.sourceValue = source;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public void setEmptyField(boolean emptyField) {
        this.emptyField = emptyField;
    }

    public void setEmptyFieldValue(String emptyFieldValue) {
        this.emptyFieldValue = emptyFieldValue;
    }

    public void setDefEmptyFieldValue(String defEmptyFieldValue) {
        this.defEmptyFieldValue = defEmptyFieldValue;
    }

    public void setUseLoadingMessage(boolean useLoadingMessage) {
        this.useLoadingMessage = useLoadingMessage;
    }
}

