/*
 * Decompiled with CFR 0.152.
 */
package org.mentawai.tag.html.ajax;

import java.nio.charset.Charset;
import java.util.LinkedList;
import javax.servlet.jsp.JspException;
import org.mentawai.tag.html.dyntag.BaseConfig;
import org.mentawai.tag.html.dyntag.FileTransfer;

public class AjaxConfig
extends BaseConfig {
    private static final long serialVersionUID = 1L;
    public static final String MENTAAJAX_DEFAULT_CHARSET = "_MENTA_DEFAULT_CHARSET";
    private boolean loadPrototype = false;
    private String charset = "UTF-8";

    protected StringBuffer buildTag() {
        LinkedList<FileTransfer> listFiles = new LinkedList<FileTransfer>();
        StringBuffer serializeForm = null;
        if (this.loadPrototype) {
            listFiles.add(new FileTransfer("css", "auto_complete.css", "/org/mentawai/tag/html/ajax/lib/", "/mtwAjax/"));
            listFiles.add(new FileTransfer("js", "prototype.js", "/org/mentawai/tag/html/ajax/lib/", "/mtwAjax/"));
            listFiles.add(new FileTransfer("js", "mentaAjax.js?v=2.6.1", "/org/mentawai/tag/html/ajax/lib/", "/mtwAjax/"));
            listFiles.add(new FileTransfer("js", "util.js", "/org/mentawai/tag/html/ajax/lib/", "/mtwAjax/"));
            listFiles.add(new FileTransfer("js", "effects.js", "/org/mentawai/tag/html/ajax/lib/", "/mtwAjax/"));
            listFiles.add(new FileTransfer("js", "ac.js", "/org/mentawai/tag/html/ajax/lib/", "/mtwAjax/"));
            listFiles.add(new FileTransfer("js", "mentaInPlace.js", "/org/mentawai/tag/html/ajax/lib/", "/mtwAjax/"));
            serializeForm = new StringBuffer();
            serializeForm.append("\n\t\t<script type=\"text/javascript\">");
            serializeForm.append("\n\t\t\t\tmtw.request.prototype.serializeForm = function(formId){");
            serializeForm.append("\n\t\t\t\t\tthis.PARS = $(formId).serialize();");
            serializeForm.append("\n\t\t\t\t}");
            serializeForm.append("\n\t\t</script>");
        } else {
            listFiles.add(new FileTransfer("js", "mentaAjax.js?v=2.6.1", "/org/mentawai/tag/html/ajax/lib/", "/mtwAjax/"));
            listFiles.add(new FileTransfer("js", "mentaInPlace.js", "/org/mentawai/tag/html/ajax/lib/", "/mtwAjax/"));
        }
        StringBuffer result = new StringBuffer();
        result.append("\n\n\t<!-- Default MentaAjax charset request -->\n\t");
        result.append("<script type=\"text/javascript\">");
        result.append(String.format("\t\tvar _MENTA_DEFAULT_CHARSET = \"%s\"; \t", this.charset));
        result.append("</script>\n\n");
        result.append(this.buldImportJsFile(listFiles).toString());
        result.append(this.buldImportCssFile(listFiles).toString());
        if (this.loadPrototype) {
            result.append(serializeForm.toString());
        }
        return result;
    }

    @Override
    public String getStringToPrint() throws JspException {
        StringBuffer results = new StringBuffer(200);
        results.append(this.buildTag().toString());
        return results.toString();
    }

    public void setLoadPrototype(boolean loadPrototype) {
        this.loadPrototype = loadPrototype;
    }

    public void setCharset(String charset) {
        this.charset = Charset.availableCharsets().containsKey(charset) ? charset : this.charset;
    }
}

