/*
 * Decompiled with CFR 0.152.
 */
package org.mentawai.tag.html;

import javax.servlet.jsp.JspException;
import javax.servlet.jsp.tagext.BodyContent;
import org.mentawai.tag.html.HTMLTag;

public class TextArea
extends HTMLTag {
    private String name;
    private String id = null;
    private String klass = null;
    private String style = null;
    private int cols = -1;
    private int rows = -1;
    private int maxlength = 0;

    public void setName(String name) {
        this.name = name;
    }

    public void setKlass(String klass) {
        this.klass = klass;
    }

    public void setStyle(String style) {
        this.style = style;
    }

    public void setId(String id) {
        this.id = id;
    }

    public void setCols(int cols) {
        this.cols = cols;
    }

    public void setRows(int rows) {
        this.rows = rows;
    }

    public void setMaxlength(int maxlength) {
        this.maxlength = maxlength;
    }

    protected StringBuffer buildTag() {
        StringBuffer sb = new StringBuffer(2000);
        sb.append("<textarea name=\"").append(this.name).append("\"");
        if (this.klass != null) {
            sb.append(" class=\"").append(this.klass).append("\"");
        }
        if (this.style != null) {
            sb.append(" style=\"").append(this.style).append("\"");
        }
        if (this.id != null) {
            sb.append(" id=\"").append(this.id).append("\"");
        }
        if (this.cols > 0) {
            sb.append(" cols=\"").append(this.cols).append("\"");
        }
        if (this.rows > 0) {
            sb.append(" rows=\"").append(this.rows).append("\"");
        }
        if (this.maxlength > 0) {
            sb.append(" onKeyDown=\"this.value=this.value.substring(0,").append(this.maxlength).append(")\" onKeyUp=\"this.value=this.value.substring(0,").append(this.maxlength).append(")\"");
        }
        sb.append(this.getExtraAttributes());
        return sb;
    }

    protected String formatText(String text) {
        return text;
    }

    @Override
    public String getStringToPrint() throws JspException {
        StringBuffer sb = new StringBuffer(200);
        sb.append(this.buildTag().toString());
        sb.append(">");
        Object value = this.findObject(this.name, false, true);
        if (value == null) {
            BodyContent bc = this.getBodyContent();
            if (bc != null) {
                String text = bc.getString();
                sb.append(text);
            }
        } else {
            sb.append(this.formatText(value.toString()));
        }
        sb.append("</textarea>");
        return sb.toString();
    }
}

