/*
 * Decompiled with CFR 0.152.
 */
package org.mentawai.tag.html;

import javax.servlet.jsp.JspException;
import javax.servlet.jsp.tagext.Tag;
import org.mentawai.i18n.I18N;
import org.mentawai.i18n.LocaleManager;
import org.mentawai.tag.html.Form;
import org.mentawai.tag.html.HTMLTag;

public class Submit
extends HTMLTag {
    public static String DEFAULT_TYPE = "button";
    private String id = null;
    private String name = null;
    private String klass = null;
    private String style = null;
    private String act = null;
    private String method = null;
    private String value = null;
    private String src = null;
    private String type = null;

    public void setId(String id) {
        this.id = id;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setKlass(String klass) {
        this.klass = klass;
    }

    public void setStyle(String style) {
        this.style = style;
    }

    public void setAction(String act) {
        this.act = act;
    }

    public void setMethod(String method) {
        this.method = method;
    }

    public void setValue(String value) {
        this.value = value;
    }

    public void setType(String type) {
        this.type = type;
    }

    public void setSrc(String src) {
        this.src = src;
    }

    @Override
    public String getStringToPrint() throws JspException {
        String submitAction;
        Tag parent = Submit.findAncestorWithClass((Tag)this, Form.class);
        if (parent == null) {
            throw new JspException("Tag submit not enclosed by form!");
        }
        Form form = (Form)parent;
        String formMethod = form.getMethod();
        String formAction = form.getAction();
        if (formAction == null && this.act == null) {
            throw new JspException("No action to submit!");
        }
        String string = submitAction = this.act != null ? this.act : formAction;
        if (formMethod == null && this.method == null) {
            throw new JspException("No method was specified!");
        }
        String submitMethod = this.method != null ? this.method : formMethod;
        String functionName = submitAction.replace('.', '_').replace('/', '_');
        StringBuilder sb = new StringBuilder(512);
        sb.append("<input");
        if (this.id != null) {
            sb.append(" id=\"").append(this.id).append("\"");
        }
        if (this.name != null) {
            sb.append(" name=\"").append(this.name).append("\"");
        }
        if (this.klass != null) {
            sb.append(" class=\"").append(this.klass).append("\"");
        }
        if (this.style != null) {
            sb.append(" style=\"").append(this.style).append("\"");
        }
        if (this.value != null) {
            if (this.value.startsWith("!") && this.value.endsWith("!") && this.value.length() > 2) {
                I18N[] props = (I18N[])this.pageContext.getAttribute("_i18n");
                String prefix = (String)this.pageContext.getAttribute("_prefix");
                String key = this.value.substring(1, this.value.length() - 1);
                if (prefix != null) {
                    key = prefix + "." + key;
                }
                String newValue = new String(this.value);
                if (props != null) {
                    for (int i = props.length - 1; i >= 0; --i) {
                        if (props[i] == null || !props[i].hasKey(key)) continue;
                        String v = props[i].get(key);
                        newValue = LocaleManager.I18N_DEBUG ? "{" + v + "}" : v;
                    }
                }
                sb.append(" value=\"").append(newValue).append("\"");
            } else {
                sb.append(" value=\"").append(this.value).append("\"");
            }
        }
        if (this.type != null) {
            sb.append(" type=\"").append(this.type).append("\"");
        } else {
            sb.append(" type=\"").append(DEFAULT_TYPE).append("\"");
        }
        if (this.src != null) {
            sb.append(" src=\"").append(this.src).append("\"");
        }
        sb.append(" onclick=\"return submit_").append(functionName).append("(this.form);\"");
        sb.append(">\n");
        sb.append("<script type=\"text/javascript\" language=\"JavaScript\">\n");
        sb.append("function submit_").append(functionName).append("(form) {\n");
        if (!submitAction.startsWith("/")) {
            submitAction = "/" + submitAction;
        }
        sb.append("\tform.action = \"").append(this.req.getContextPath()).append(submitAction).append("\";\n");
        sb.append("\tform.method = \"").append(submitMethod).append("\";\n");
        sb.append("\tform.submit();\n");
        sb.append("\treturn false;\n");
        sb.append("}\n");
        sb.append("</script>\n");
        return sb.toString();
    }
}

