/*
 * Decompiled with CFR 0.152.
 */
package org.mentawai.tag.html;

import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.servlet.jsp.JspException;
import javax.servlet.jsp.tagext.Tag;
import javax.servlet.jsp.tagext.TagAdapter;
import net.sf.json.JSONArray;
import net.sf.json.JSONObject;
import org.mentawai.i18n.I18N;
import org.mentawai.list.ListData;
import org.mentawai.list.ListItem;
import org.mentawai.list.ListManager;
import org.mentawai.tag.Out;
import org.mentawai.tag.html.HTMLTag;
import org.mentawai.tag.html.ajax.InPlaceTag;

public class Select
extends HTMLTag {
    private String name;
    private String listname;
    private boolean noSelect = false;
    private int size = -1;
    private boolean emptyField = false;
    private String emptyFieldValue = null;
    private String defEmptyFieldValue = null;
    private String klass = null;
    private String style = null;
    private String id = null;
    private boolean multiple = false;
    private String defValue = null;

    public void setName(String name) {
        this.name = name;
    }

    public void setList(String listname) {
        this.listname = listname;
    }

    public void setNoSelect(boolean noSelect) {
        this.noSelect = noSelect;
    }

    public void setEmptyFieldValue(String emptyFieldValue) {
        this.emptyFieldValue = emptyFieldValue;
    }

    public void setDefEmptyFieldValue(String defEmptyFieldValue) {
        this.defEmptyFieldValue = defEmptyFieldValue;
    }

    public void setSize(int size) {
        this.size = size;
    }

    public void setEmptyField(boolean emptyField) {
        this.emptyField = emptyField;
    }

    public void setKlass(String klass) {
        this.klass = klass;
    }

    public void setStyle(String style) {
        this.style = style;
    }

    public void setId(String id) {
        this.id = id;
    }

    public void setMultiple(boolean multiple) {
        this.multiple = multiple;
    }

    public void setDefValue(String defValue) {
        this.defValue = defValue;
    }

    protected StringBuffer buildTag() {
        StringBuffer sb = new StringBuffer(150);
        sb.append("<select name=\"");
        sb.append(this.name);
        sb.append("\"");
        if (this.size > 1) {
            sb.append(" size=\"").append(this.size).append("\"");
        }
        if (this.klass != null) {
            sb.append(" class=\"").append(this.klass).append("\"");
        }
        if (this.style != null) {
            sb.append(" style=\"").append(this.style).append("\"");
        }
        if (this.id != null) {
            sb.append(" id=\"").append(this.id).append("\"");
        }
        if (this.multiple) {
            sb.append(" multiple=\"true\"");
        }
        sb.append(this.getExtraAttributes());
        return sb;
    }

    public boolean isInPlaceTagIntegration() throws JspException {
        Tag parent = this.getParent();
        if (parent != null) {
            InPlaceTag ipt = null;
            try {
                ipt = (InPlaceTag)((TagAdapter)parent).getAdaptee();
            }
            catch (ClassCastException e) {
                return false;
            }
            try {
                Iterator<ListItem> iterator = this.findValuesOut().iterator();
                JSONObject obj = new JSONObject();
                JSONArray array = new JSONArray();
                while (iterator.hasNext()) {
                    ListItem li = iterator.next();
                    JSONObject o = new JSONObject();
                    o.put((Object)"key", (Object)li.getKey());
                    o.put((Object)"value", (Object)li.getValue());
                    array.add((Object)o);
                }
                obj.put((Object)"obj", (Object)array);
                ipt.setSelectOptions(obj);
            }
            catch (Exception e) {
                throw new JspException((Throwable)e);
            }
            ipt.setType("select");
            if (this.size > 0) {
                ipt.setSize(Short.parseShort(String.valueOf(this.size)));
            }
            if (this.klass != null) {
                ipt.setKlass(this.klass);
            }
            if (this.style != null) {
                ipt.setStyle(this.style);
            }
            if (this.multiple) {
                ipt.setMultiple(this.multiple);
            }
            if (this.name != null) {
                ipt.setName(this.name);
            }
            return true;
        }
        return false;
    }

    private List<ListItem> findValuesOut() throws JspException {
        ListData list = null;
        Object obj = Out.getValue(this.listname, this.pageContext, false);
        if (obj != null && obj instanceof ListData) {
            list = (ListData)obj;
        } else if (obj != null && obj instanceof Map) {
            list = ListManager.convert(this.listname, (Map)obj);
        } else if (obj != null && obj instanceof Collection) {
            list = ListManager.convert(this.listname, (Collection)obj);
        } else if (obj != null && obj.getClass().isArray()) {
            Object[] array = (Object[])obj;
            list = ListManager.convert(this.listname, Arrays.asList(array));
        } else {
            list = ListManager.getList(this.listname);
        }
        if (list == null) {
            throw new JspException("Cannot find list: " + this.listname);
        }
        List<ListItem> items = list.getValues(this.loc);
        if (items == null) {
            throw new JspException("Cannot find list for the locale: " + this.listname + " / " + this.loc);
        }
        return items;
    }

    @Override
    public String getStringToPrint() throws JspException {
        if (this.isInPlaceTagIntegration()) {
            return "";
        }
        String[] values = this.findValues(this.name, false, true);
        List<ListItem> findValuesOut = this.findValuesOut();
        StringBuffer sb = new StringBuffer(findValuesOut.size() * 50);
        Iterator<ListItem> iter = findValuesOut.iterator();
        if (!this.noSelect) {
            sb.append(this.buildTag().toString());
            sb.append(">\n");
        }
        String keyValue = this.defEmptyFieldValue;
        if (this.defEmptyFieldValue == null) {
            keyValue = "";
        }
        if (this.emptyField) {
            if (this.emptyFieldValue != null) {
                String value = null;
                if (this.emptyFieldValue.length() >= 3 && this.emptyFieldValue.startsWith("!") && this.emptyFieldValue.endsWith("!")) {
                    I18N[] props = (I18N[])this.pageContext.getAttribute("_i18n");
                    String prefix = (String)this.pageContext.getAttribute("_prefix");
                    if (props != null) {
                        String key = this.emptyFieldValue.substring(1, this.emptyFieldValue.length() - 1);
                        if (prefix != null) {
                            String prefixKey = prefix + "." + key;
                            for (int i = props.length - 1; i >= 0; --i) {
                                if (props[i] == null || !props[i].hasKey(prefixKey)) continue;
                                value = props[i].get(prefixKey);
                                break;
                            }
                        }
                        if (value == null) {
                            for (int i = props.length - 1; i >= 0; --i) {
                                if (props[i] == null || !props[i].hasKey(key)) continue;
                                value = props[i].get(key);
                                break;
                            }
                        }
                    }
                }
                if (value != null) {
                    sb.append("<option value=\"" + keyValue + "\">").append(value).append("</option>\n");
                } else {
                    sb.append("<option value=\"" + keyValue + "\">").append(this.emptyFieldValue).append("</option>\n");
                }
            } else {
                sb.append("<option value=\"" + keyValue + "\"> - </option>\n");
            }
        }
        while (iter.hasNext()) {
            ListItem item = iter.next();
            String id = item.getKey();
            String n = item.getValue();
            sb.append("<option value=\"");
            sb.append(id);
            sb.append("\"");
            if ((values == null || values.length == 0) && this.defValue != null && this.defValue.equals(id)) {
                sb.append(" selected=\"selected\">");
            } else if (this.contains(values, id)) {
                sb.append(" selected=\"selected\">");
            } else {
                sb.append(">");
            }
            sb.append(n).append("</option>\n");
        }
        if (!this.noSelect) {
            sb.append("</select>\n");
        }
        return sb.toString();
    }
}

