/*
 * Decompiled with CFR 0.152.
 */
package org.mentawai.tag.html;

import java.util.Collection;
import java.util.Iterator;
import javax.servlet.jsp.JspException;
import javax.servlet.jsp.tagext.Tag;
import org.mentawai.core.BaseAction;
import org.mentawai.core.Input;
import org.mentawai.core.Output;
import org.mentawai.tag.Out;
import org.mentawai.tag.util.Context;
import org.mentawai.tag.util.PrintTag;

public abstract class HTMLTag
extends PrintTag {
    private static final String SEPARATOR = "#";
    private String extra;
    private String separator = "#";

    public void setExtra(String extra) {
        this.extra = extra;
    }

    public void setSeparator(String separator) {
        this.separator = separator;
    }

    protected String getExtraAttributes() {
        if (this.extra == null) {
            return "";
        }
        StringBuffer sb = new StringBuffer(512);
        String[] s = this.extra.split("\\" + this.separator);
        for (int i = 0; i < s.length; ++i) {
            String[] ss = s[i].split("=");
            if (ss.length != 2) continue;
            sb.append(" ").append(ss[0].trim()).append("=\"").append(ss[1].trim()).append('\"');
        }
        return sb.toString();
    }

    protected Object findObject(String name) {
        return this.findObject(name, false, false);
    }

    protected Object findObject(String name, boolean tryBoolean, boolean inputFirst) {
        Object value = null;
        if (inputFirst && this.action != null && BaseAction.isPost(this.action) && this.action.getInput().has(name)) {
            return this.action.getInput().getValue(name);
        }
        Tag parent = HTMLTag.findAncestorWithClass((Tag)this, Context.class);
        if (parent != null) {
            try {
                value = Out.getValue(parent, name, this.pageContext, tryBoolean);
                if (value != null && !value.equals("")) {
                    return value;
                }
            }
            catch (JspException e) {
                // empty catch block
            }
        }
        if (this.action == null) {
            return null;
        }
        Output output = this.action.getOutput();
        Input input = this.action.getInput();
        value = output.getValue(name);
        if (value == null && (value = input.getValue(name)) == null) {
            value = this.session.getAttribute(name);
        }
        return value;
    }

    protected String findValue(String name) {
        Object value = this.findObject(name);
        if (value == null) {
            return null;
        }
        return value.toString();
    }

    protected String findValue(String name, boolean tryBoolean, boolean inputFirst) {
        Object value = this.findObject(name, tryBoolean, inputFirst);
        if (value == null) {
            return null;
        }
        return value.toString();
    }

    protected boolean contains(int[] values, int x) {
        if (values == null) {
            return false;
        }
        for (int i = 0; i < values.length; ++i) {
            if (values[i] != x) continue;
            return true;
        }
        return false;
    }

    protected boolean contains(String[] values, String x) {
        if (values == null) {
            return false;
        }
        for (int i = 0; i < values.length; ++i) {
            if (values[i] == null || !values[i].equals(x)) continue;
            return true;
        }
        return false;
    }

    protected String[] findValues(String name) {
        return this.findValues(name, false, false);
    }

    protected String[] findValues(String name, boolean tryBoolean, boolean inputFirst) {
        Object value = this.findObject(name, tryBoolean, inputFirst);
        if (value == null) {
            return null;
        }
        if (value instanceof int[]) {
            int[] x = (int[])value;
            String[] s = new String[x.length];
            for (int i = 0; i < x.length; ++i) {
                s[i] = String.valueOf(x[i]);
            }
            return s;
        }
        if (value instanceof String[]) {
            return (String[])value;
        }
        if (value instanceof Integer) {
            String[] x = new String[]{String.valueOf((Integer)value)};
            return x;
        }
        if (value instanceof Number) {
            String[] x = new String[]{value.toString()};
            return x;
        }
        if (value instanceof String) {
            String[] x = new String[]{(String)value};
            return x;
        }
        if (value instanceof Enum) {
            String[] x = new String[]{value.toString()};
            return x;
        }
        if (value instanceof Collection) {
            Collection c = (Collection)value;
            String[] x = new String[c.size()];
            int index = 0;
            Iterator iter = c.iterator();
            while (iter.hasNext()) {
                x[index++] = iter.next().toString();
            }
            return x;
        }
        if (value instanceof Boolean) {
            return new String[]{String.valueOf(value)};
        }
        return null;
    }
}

