/*
 * Decompiled with CFR 0.152.
 */
package org.mentawai.tag.authorization;

import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.StringTokenizer;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import javax.servlet.jsp.JspException;
import javax.servlet.jsp.tagext.TagSupport;
import org.mentawai.action.BaseLoginAction;
import org.mentawai.authorization.AuthorizationManager;
import org.mentawai.authorization.Group;
import org.mentawai.core.Action;
import org.mentawai.core.ApplicationManager;
import org.mentawai.core.Consequence;
import org.mentawai.core.ConsequenceException;
import org.mentawai.core.Forward;
import org.mentawai.i18n.LocaleManager;

public class RequiresAuthorization
extends TagSupport {
    private static final String HEADER_KEY_PRAGMA = "Pragma";
    private static final String HEADER_KEY_CACHECONTROL = "Cache-Control";
    private static final String HEADER_VALUE_NOCACHE = "no-cache";
    protected HttpSession session = null;
    protected HttpServletRequest req = null;
    protected HttpServletResponse res = null;
    protected Action action = null;
    protected Locale loc = null;
    protected ApplicationManager appManager = null;
    private boolean both = false;
    private boolean cache = false;
    private List<String> groups;
    private List<String> permissions;
    private List listGroups;

    public void setCache(boolean cache) {
        this.cache = cache;
    }

    public void setBoth(boolean both) {
        this.both = this.permissions != null && this.permissions.size() > 0 ? both : false;
    }

    public void setGroups(String groups) {
        StringTokenizer st = new StringTokenizer(groups, ",");
        this.groups = new ArrayList<String>(st.countTokens());
        while (st.hasMoreTokens()) {
            this.groups.add(st.nextToken().trim());
        }
    }

    public void setGroup(String group) {
        this.groups = new ArrayList<String>(1);
        this.groups.add(group.trim());
    }

    public void setPermission(String permission) {
        this.setPermissions(permission);
    }

    public void setPermissions(String permissions) {
        StringTokenizer st = new StringTokenizer(permissions, ",");
        this.permissions = new ArrayList<String>(st.countTokens());
        while (st.hasMoreTokens()) {
            this.permissions.add(st.nextToken().trim());
        }
    }

    public int doStartTag() throws JspException {
        this.session = this.pageContext.getSession();
        this.req = (HttpServletRequest)this.pageContext.getRequest();
        this.res = (HttpServletResponse)this.pageContext.getResponse();
        this.action = (Action)this.req.getAttribute(Forward.ACTION_REQUEST);
        this.loc = LocaleManager.getLocale(this.req);
        this.appManager = ApplicationManager.getInstance();
        return super.doStartTag();
    }

    private void executeConsequence() throws JspException {
        Consequence c = this.appManager.getGlobalConsequence("accessdenied");
        if (c != null) {
            try {
                c.execute(this.action, "accessdenied", this.req, this.res);
            }
            catch (ConsequenceException e) {
                e.printStackTrace();
                throw new JspException((Throwable)e);
            }
        } else {
            throw new JspException("No global consequence defined for ACCESSDENIED!");
        }
    }

    public int doEndTag() throws JspException {
        Group g;
        if (!this.cache) {
            this.res.setHeader(HEADER_KEY_PRAGMA, HEADER_VALUE_NOCACHE);
            this.res.setHeader(HEADER_KEY_CACHECONTROL, HEADER_VALUE_NOCACHE);
        }
        List<Object> usergroups = BaseLoginAction.getUserGroups(this.session);
        boolean haveGroup = false;
        boolean havePermission = false;
        if (usergroups == null || usergroups.size() == 0) {
            this.executeConsequence();
            return 5;
        }
        if (this.groups != null && this.groups.size() > 0) {
            for (int i = 0; i < this.groups.size(); ++i) {
                for (int j = 0; j < usergroups.size(); ++j) {
                    if (usergroups.get(j) instanceof String) {
                        if (this.groups.get(i).toString().equalsIgnoreCase(usergroups.get(j).toString())) {
                            haveGroup = true;
                            continue;
                        }
                        if (!this.groups.get(i).toString().equalsIgnoreCase("!" + usergroups.get(j).toString())) continue;
                        haveGroup = false;
                        continue;
                    }
                    if (usergroups.get(j) instanceof Group) {
                        g = (Group)usergroups.get(j);
                        if (this.groups.get(i).toString().equalsIgnoreCase(g.getName())) {
                            haveGroup = true;
                            continue;
                        }
                        if (!this.groups.get(i).toString().equalsIgnoreCase("!" + g.getName())) continue;
                        haveGroup = false;
                        continue;
                    }
                    if (!(usergroups.get(j) instanceof List)) continue;
                    this.listGroups = (List)usergroups.get(j);
                    for (int k = 0; k < this.listGroups.size(); ++k) {
                        Group g2 = (Group)this.listGroups.get(k);
                        if (this.groups.get(i).toString().equalsIgnoreCase(g2.getName().toString())) {
                            haveGroup = true;
                        } else if (this.groups.get(i).toString().equalsIgnoreCase("!" + g2.getName().toString())) {
                            haveGroup = false;
                        }
                        if (!haveGroup) continue;
                        k = this.listGroups.size();
                    }
                }
            }
        }
        if (this.permissions != null && this.permissions.size() > 0) {
            for (int j = 0; j < usergroups.size(); ++j) {
                if (usergroups.get(j) instanceof String) {
                    if (!AuthorizationManager.checkAny(usergroups.get(j).toString(), this.permissions)) continue;
                    havePermission = true;
                    continue;
                }
                if (usergroups.get(j) instanceof Group) {
                    Group g3 = (Group)usergroups.get(j);
                    if (!AuthorizationManager.checkAny(g3, this.permissions)) continue;
                    havePermission = true;
                    continue;
                }
                if (!(usergroups.get(j) instanceof List)) continue;
                this.listGroups = (List)usergroups.get(j);
                for (int k = 0; k < this.listGroups.size(); ++k) {
                    g = (Group)this.listGroups.get(k);
                    havePermission = AuthorizationManager.checkAny(g, this.permissions);
                }
            }
        }
        if (this.both) {
            if (haveGroup && havePermission) {
                return 6;
            }
            this.executeConsequence();
            return 5;
        }
        if (haveGroup || havePermission) {
            return 6;
        }
        this.executeConsequence();
        return 5;
    }
}

