/*
 * Decompiled with CFR 0.152.
 */
package org.mentawai.tag.authorization;

import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;
import javax.servlet.jsp.JspException;
import org.mentawai.action.BaseLoginAction;
import org.mentawai.authorization.AuthorizationManager;
import org.mentawai.authorization.Group;
import org.mentawai.tag.util.ConditionalTag;

public class HasAuthorization
extends ConditionalTag {
    private List<String> groups;
    private List<String> permissions;
    private List<Group> listGroups;
    private boolean both = false;

    public void setGroup(String group) {
        this.groups = new ArrayList<String>(1);
        this.groups.add(group.trim());
    }

    public void setGroups(String groups) {
        StringTokenizer st = new StringTokenizer(groups, ",");
        this.groups = new ArrayList<String>(st.countTokens());
        while (st.hasMoreTokens()) {
            this.groups.add(st.nextToken().trim());
        }
    }

    public void setPermission(String permission) {
        this.setPermissions(permission);
    }

    public void setBoth(boolean both) {
        this.both = this.permissions != null && this.permissions.size() > 0 ? both : false;
    }

    public void setPermissions(String permissions) {
        StringTokenizer st = new StringTokenizer(permissions, ",");
        this.permissions = new ArrayList<String>(st.countTokens());
        while (st.hasMoreTokens()) {
            this.permissions.add(st.nextToken().trim());
        }
    }

    @Override
    public boolean testCondition() throws JspException {
        Group g;
        List<Object> usergroups = BaseLoginAction.getUserGroups(this.session);
        boolean haveGroup = false;
        boolean havePermission = false;
        if (usergroups == null || usergroups.size() == 0) {
            return false;
        }
        if (this.groups != null && this.groups.size() > 0) {
            for (int i = 0; i < this.groups.size(); ++i) {
                for (int j = 0; j < usergroups.size(); ++j) {
                    if (usergroups.get(j) instanceof String) {
                        if (this.groups.get(i).toString().equalsIgnoreCase(usergroups.get(j).toString())) {
                            haveGroup = true;
                            continue;
                        }
                        if (!this.groups.get(i).toString().equalsIgnoreCase("!" + usergroups.get(j).toString())) continue;
                        return false;
                    }
                    if (usergroups.get(j) instanceof Group) {
                        g = (Group)usergroups.get(j);
                        if (this.groups.get(i).toString().equalsIgnoreCase(g.getName())) {
                            haveGroup = true;
                            continue;
                        }
                        if (!this.groups.get(i).toString().equalsIgnoreCase("!" + g.getName())) continue;
                        return false;
                    }
                    if (!(usergroups.get(j) instanceof List)) continue;
                    this.listGroups = (List)usergroups.get(j);
                    for (int k = 0; k < this.listGroups.size(); ++k) {
                        Group g2 = this.listGroups.get(k);
                        if (this.groups.get(i).toString().equalsIgnoreCase(g2.getName().toString())) {
                            haveGroup = true;
                        } else if (this.groups.get(i).toString().equalsIgnoreCase("!" + g2.getName().toString())) {
                            return false;
                        }
                        if (!haveGroup) continue;
                        k = this.listGroups.size();
                    }
                }
            }
        }
        if (this.permissions != null && this.permissions.size() > 0) {
            for (int j = 0; j < usergroups.size(); ++j) {
                if (usergroups.get(j) instanceof String) {
                    if (!AuthorizationManager.checkAny(usergroups.get(j).toString(), this.permissions)) continue;
                    havePermission = true;
                    continue;
                }
                if (usergroups.get(j) instanceof Group) {
                    Group g3 = (Group)usergroups.get(j);
                    if (!AuthorizationManager.checkAny(g3, this.permissions)) continue;
                    havePermission = true;
                    continue;
                }
                if (!(usergroups.get(j) instanceof List)) continue;
                this.listGroups = (List)usergroups.get(j);
                for (int k = 0; k < this.listGroups.size(); ++k) {
                    g = this.listGroups.get(k);
                    havePermission = AuthorizationManager.checkAny(g, this.permissions);
                }
            }
        }
        if (this.both) {
            return haveGroup && havePermission;
        }
        return haveGroup || havePermission;
    }
}

