/*
 * Decompiled with CFR 0.152.
 */
package org.mentawai.tag.authentication;

import java.util.Locale;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import javax.servlet.jsp.JspException;
import javax.servlet.jsp.tagext.TagSupport;
import org.mentawai.action.BaseLoginAction;
import org.mentawai.action.SuccessAction;
import org.mentawai.core.Action;
import org.mentawai.core.ApplicationContext;
import org.mentawai.core.ApplicationManager;
import org.mentawai.core.Consequence;
import org.mentawai.core.ConsequenceException;
import org.mentawai.core.CookieContext;
import org.mentawai.core.Forward;
import org.mentawai.core.Redirect;
import org.mentawai.core.RequestInput;
import org.mentawai.core.ResponseOutput;
import org.mentawai.core.SessionContext;
import org.mentawai.filter.AuthenticationFilter;
import org.mentawai.i18n.LocaleManager;

public class RequiresAuthentication
extends TagSupport {
    private static final String HEADER_KEY_PRAGMA = "Pragma";
    private static final String HEADER_KEY_CACHECONTROL = "Cache-Control";
    private static final String HEADER_VALUE_NOCACHE = "no-cache";
    protected HttpSession session = null;
    protected HttpServletRequest req = null;
    protected HttpServletResponse res = null;
    protected ServletContext sc = null;
    protected Action action = null;
    protected Locale loc = null;
    protected ApplicationManager appManager = null;
    private boolean redir = false;
    private boolean cache = false;
    private String loginPage = null;

    public void setRedir(boolean redir) {
        this.redir = redir;
    }

    public void setCache(boolean cache) {
        this.cache = cache;
    }

    public void setLoginPage(String page) {
        this.loginPage = page;
    }

    public int doStartTag() throws JspException {
        this.session = this.pageContext.getSession();
        this.req = (HttpServletRequest)this.pageContext.getRequest();
        this.res = (HttpServletResponse)this.pageContext.getResponse();
        this.sc = this.pageContext.getServletContext();
        this.action = (Action)this.req.getAttribute(Forward.ACTION_REQUEST);
        this.loc = LocaleManager.getLocale(this.req);
        this.appManager = ApplicationManager.getInstance();
        return super.doStartTag();
    }

    public int doEndTag() throws JspException {
        if (!this.cache) {
            this.res.setHeader(HEADER_KEY_PRAGMA, HEADER_VALUE_NOCACHE);
            this.res.setHeader(HEADER_KEY_CACHECONTROL, HEADER_VALUE_NOCACHE);
        }
        if (!BaseLoginAction.isLogged(this.session)) {
            if (this.redir) {
                AuthenticationFilter.setCallbackUrl(this.session, this.req);
            }
            Consequence redir = null;
            if (this.loginPage != null) {
                redir = new Redirect(this.loginPage);
            } else {
                redir = this.appManager.getGlobalConsequence("login");
                if (redir == null) {
                    throw new JspException("Cannot find global consequence for LOGIN! Don't know where to redirect unauthorized user!");
                }
            }
            Action a = null;
            if (this.action != null) {
                a = this.action;
            } else {
                a = new SuccessAction();
                a.setInput(new RequestInput(this.req));
                a.setOutput(new ResponseOutput(this.res));
                a.setSession(new SessionContext(this.req, this.res));
                a.setApplication(new ApplicationContext(this.sc));
                a.setCookies(new CookieContext(this.req, this.res));
                a.setLocale(this.loc);
            }
            try {
                redir.execute(a, "login", this.req, this.res);
            }
            catch (ConsequenceException e) {
                e.printStackTrace();
                throw new JspException((Throwable)e);
            }
            return 5;
        }
        return 6;
    }
}

