/*
 * Decompiled with CFR 0.152.
 */
package org.mentawai.tag;

import javax.servlet.jsp.JspException;
import javax.servlet.jsp.tagext.Tag;
import org.mentaregex.Regex;
import org.mentawai.tag.Out;
import org.mentawai.tag.util.ConditionalTag;
import org.mentawai.tag.util.Context;

public class IfTag
extends ConditionalTag {
    private String test = null;
    private String value = null;
    private String dynValue = null;

    public void setTest(String test) {
        this.test = test;
    }

    public void setValue(String value) {
        this.value = value;
    }

    public void setDynValue(String dynValue) {
        this.dynValue = dynValue;
    }

    @Override
    public boolean testCondition() throws JspException {
        Boolean b;
        String s;
        if (this.dynValue != null && this.value != null) {
            throw new JspException("Invalid IfTag: cannot have value and dynValue at the same time!");
        }
        Tag parent = IfTag.findAncestorWithClass((Tag)this, Context.class);
        Object obj = Out.getValue(parent, this.test, this.pageContext, true);
        Object dynObj = null;
        if (this.dynValue != null) {
            dynObj = Out.getValue(parent, this.dynValue, this.pageContext, true);
        }
        if (obj == null) {
            if (this.value != null && this.value.equals("null")) {
                return true;
            }
            if (this.dynValue != null && dynObj == null) {
                return true;
            }
            if (this.test.startsWith("param.")) {
                s = Regex.sub(this.test, "s/param\\.//");
                if (s.trim().length() == 0) {
                    return false;
                }
                obj = this.req.getParameter(s);
                if (obj == null || obj.toString().trim().length() == 0) {
                    return false;
                }
            } else {
                return false;
            }
        }
        if (obj instanceof Boolean && this.dynValue == null && this.value == null) {
            b = (Boolean)obj;
            return b;
        }
        if (this.dynValue != null) {
            if (dynObj == null) {
                return false;
            }
            return obj.equals(dynObj);
        }
        if (obj instanceof Boolean) {
            b = (Boolean)obj;
            if (this.value != null) {
                if (!this.value.equalsIgnoreCase("false") && !this.value.equalsIgnoreCase("true")) {
                    throw new JspException("Invalid IfTag: value must be a boolean: " + this.test + " / " + this.value);
                }
                boolean flag = this.value.equalsIgnoreCase("true");
                return b == flag;
            }
            return b;
        }
        if (obj instanceof Integer) {
            Integer i = (Integer)obj;
            if (this.value == null) {
                throw new JspException("Invalid IfTag: value must be present for integer: " + this.test);
            }
            if (this.value.indexOf(",") > 0) {
                String[] s2 = this.value.split("\\s*,\\s*");
                int[] array = new int[s2.length];
                try {
                    int x;
                    for (x = 0; x < array.length; ++x) {
                        array[x] = Integer.parseInt(s2[x]);
                    }
                    for (x = 0; x < array.length; ++x) {
                        if (array[x] != i) continue;
                        return true;
                    }
                    return false;
                }
                catch (Exception e) {
                    // empty catch block
                }
            }
            try {
                return i == Integer.parseInt(this.value);
            }
            catch (NumberFormatException e) {
                throw new JspException("Invalid IfTag: value must be an integer: " + this.test + " / " + this.value);
            }
        }
        if (obj instanceof Character) {
            Character c = (Character)obj;
            if (this.value == null) {
                throw new JspException("Invalid IfTag: value must be present for character: " + this.test);
            }
            if (this.value.length() != 1) {
                throw new JspException("Invalid IfTag: value is not a char: " + this.value);
            }
            return c.charValue() == this.value.charAt(0);
        }
        if (obj instanceof Enum) {
            s = obj.toString();
            return s.equals(this.value);
        }
        if (obj instanceof String) {
            String objString = (String)obj;
            if (this.value == null) {
                throw new JspException("Invalid IfTag: value must be present for String: " + this.test);
            }
            if (this.value.indexOf(",") > 0) {
                String[] s3;
                for (String x : s3 = this.value.split("\\s*,\\s*")) {
                    if (!objString.equals(x)) continue;
                    return true;
                }
                return false;
            }
            return objString.equals(this.value);
        }
        if (this.value == null) {
            throw new JspException("Invalid IfTag: value must be present: " + this.test);
        }
        return this.value.equals(obj);
    }
}

