/*
 * Decompiled with CFR 0.152.
 */
package org.mentawai.spring;

import javax.servlet.ServletContext;
import org.mentawai.core.Action;
import org.mentawai.core.ActionConfig;
import org.mentawai.core.Controller;
import org.mentawai.core.PojoAction;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.web.context.support.WebApplicationContextUtils;

public class SpringActionConfig
extends ActionConfig {
    private static BeanFactory beanFactory = null;
    private String beanName = null;

    public SpringActionConfig(String beanName) {
        super(Object.class);
        this.beanName = beanName;
    }

    public SpringActionConfig(String name, String beanName) {
        super(name, Object.class);
        this.beanName = beanName;
    }

    public SpringActionConfig(String name, String beanName, String innerAction) {
        super(name, Object.class, innerAction);
        this.beanName = beanName;
    }

    public static void setBeanFactory(BeanFactory beanFactory) {
        SpringActionConfig.beanFactory = beanFactory;
    }

    @Override
    public Action getAction() {
        Object instance = beanFactory.getBean(this.beanName);
        if (instance instanceof Action) {
            return (Action)instance;
        }
        return new PojoAction(instance);
    }

    @Override
    public Class<? extends Object> getActionClass() {
        return beanFactory.getType(this.beanName);
    }

    static {
        try {
            beanFactory = WebApplicationContextUtils.getWebApplicationContext((ServletContext)Controller.getApplication());
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

