/*
 * Decompiled with CFR 0.152.
 */
package org.mentawai.rule;

import java.text.DateFormat;
import java.text.ParseException;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import org.mentawai.rule.LocaleRule;

public class TimeRule
extends LocaleRule {
    private static final Map<String, TimeRule> cache = new HashMap<String, TimeRule>();
    private static final int STYLE = 3;
    private int style = 3;

    public TimeRule() {
    }

    public TimeRule(int style) {
        this.style = style;
    }

    public static TimeRule getInstance() {
        String key = "null";
        TimeRule tr = cache.get(key);
        if (tr != null) {
            return tr;
        }
        tr = new TimeRule();
        cache.put(key, tr);
        return tr;
    }

    public static TimeRule getInstance(int style) {
        String key = String.valueOf(style);
        TimeRule tr = cache.get(key);
        if (tr != null) {
            return tr;
        }
        tr = new TimeRule(style);
        cache.put(key, tr);
        return tr;
    }

    @Override
    public boolean check(String value, Locale locale) {
        DateFormat df = DateFormat.getTimeInstance(this.style, locale);
        df.setLenient(false);
        try {
            df.parse(value);
            return true;
        }
        catch (ParseException e) {
            return false;
        }
    }

    @Override
    public Map<String, String> getTokens() {
        return null;
    }
}

