/*
 * Decompiled with CFR 0.152.
 */
package org.mentawai.rule;

import java.util.HashMap;
import java.util.Map;
import org.mentawai.rule.BasicRule;

public class StringRule
extends BasicRule {
    private static final Map<String, StringRule> cache = new HashMap<String, StringRule>();
    private boolean noMin = true;
    private boolean noMax = true;
    private int min;
    private int max;
    private Map<String, String> tokens = new HashMap<String, String>();

    public StringRule() {
    }

    public StringRule(int min) {
        if (min < 0) {
            throw new IllegalArgumentException("min cannot be negative for strings!");
        }
        this.noMin = false;
        this.min = min;
        this.tokens.put("min", String.valueOf(min));
    }

    public StringRule(int min, int max) {
        this(min);
        if (max <= 0) {
            throw new IllegalArgumentException("max cannot be negative or zero for strings!");
        }
        this.noMax = false;
        this.max = max;
        this.tokens.put("max", String.valueOf(max));
    }

    public static StringRule getInstance() {
        String key = "null_null";
        StringRule ir = cache.get(key);
        if (ir != null) {
            return ir;
        }
        ir = new StringRule();
        cache.put(key, ir);
        return ir;
    }

    public static StringRule getInstance(int min) {
        StringBuilder sb = new StringBuilder(16);
        sb.append(min).append("_null");
        String key = sb.toString();
        StringRule ir = cache.get(key);
        if (ir != null) {
            return ir;
        }
        ir = new StringRule(min);
        cache.put(key, ir);
        return ir;
    }

    public static StringRule getInstance(int min, int max) {
        StringBuilder sb = new StringBuilder(16);
        sb.append(min).append('_').append(max);
        String key = sb.toString();
        StringRule ir = cache.get(key);
        if (ir != null) {
            return ir;
        }
        ir = new StringRule(min, max);
        cache.put(key, ir);
        return ir;
    }

    @Override
    public Map<String, String> getTokens() {
        return this.tokens;
    }

    @Override
    public boolean check(String value) {
        if (!this.noMin && value.length() < this.min) {
            return false;
        }
        return this.noMax || value.length() <= this.max;
    }
}

