/*
 * Decompiled with CFR 0.152.
 */
package org.mentawai.rule;

import java.util.HashMap;
import java.util.Map;
import org.mentawai.core.Action;
import org.mentawai.rule.Rule;

public class OptionsRule
implements Rule {
    private boolean noMin = false;
    private boolean noMax = true;
    private int min;
    private int max;
    private Map<String, String> tokens = new HashMap<String, String>();
    private static final Map<String, OptionsRule> cache = new HashMap<String, OptionsRule>();

    public OptionsRule(int min) {
        this.min = min;
        this.tokens.put("min", String.valueOf(min));
    }

    public OptionsRule(int min, int max) {
        this(min);
        this.noMax = false;
        this.max = max;
        this.tokens.put("max", String.valueOf(max));
    }

    public static OptionsRule getInstance(int min) {
        StringBuilder sb = new StringBuilder(16);
        sb.append(min).append("_null");
        String key = sb.toString();
        OptionsRule ir = cache.get(key);
        if (ir != null) {
            return ir;
        }
        ir = new OptionsRule(min);
        cache.put(key, ir);
        return ir;
    }

    public static OptionsRule getInstance(int min, int max) {
        StringBuilder sb = new StringBuilder(16);
        sb.append(min).append('_').append(max);
        String key = sb.toString();
        OptionsRule ir = cache.get(key);
        if (ir != null) {
            return ir;
        }
        ir = new OptionsRule(min, max);
        cache.put(key, ir);
        return ir;
    }

    @Override
    public Map<String, String> getTokens() {
        return this.tokens;
    }

    @Override
    public boolean check(String field, Action action) {
        int[] options = action.getInput().getInts(field);
        if (options == null) {
            return true;
        }
        if (!this.noMin && options.length < this.min) {
            return false;
        }
        return this.noMax || options.length <= this.max;
    }
}

