/*
 * Decompiled with CFR 0.152.
 */
package org.mentawai.rule;

import java.util.HashMap;
import java.util.Map;
import org.mentawai.rule.BasicRule;

public class IntegerRule
extends BasicRule {
    private boolean noMin = true;
    private boolean noMax = true;
    private int min;
    private int max;
    private Map<String, String> tokens = new HashMap<String, String>();
    private static final Map<String, IntegerRule> cache = new HashMap<String, IntegerRule>();

    public IntegerRule() {
    }

    public IntegerRule(int min) {
        this.noMin = false;
        this.min = min;
        this.tokens.put("min", String.valueOf(min));
    }

    public IntegerRule(int min, int max) {
        this(min);
        this.noMax = false;
        this.max = max;
        this.tokens.put("max", String.valueOf(max));
    }

    public static IntegerRule getInstance() {
        String key = "null_null";
        IntegerRule ir = cache.get(key);
        if (ir != null) {
            return ir;
        }
        ir = new IntegerRule();
        cache.put(key, ir);
        return ir;
    }

    public static IntegerRule getInstance(int min) {
        StringBuilder sb = new StringBuilder(16);
        sb.append(min).append("_null");
        String key = sb.toString();
        IntegerRule ir = cache.get(key);
        if (ir != null) {
            return ir;
        }
        ir = new IntegerRule(min);
        cache.put(key, ir);
        return ir;
    }

    public static IntegerRule getInstance(int min, int max) {
        StringBuilder sb = new StringBuilder(16);
        sb.append(min).append('_').append(max);
        String key = sb.toString();
        IntegerRule ir = cache.get(key);
        if (ir != null) {
            return ir;
        }
        ir = new IntegerRule(min, max);
        cache.put(key, ir);
        return ir;
    }

    @Override
    public Map<String, String> getTokens() {
        return this.tokens;
    }

    @Override
    public boolean check(String value) {
        try {
            int x = Integer.parseInt(value);
            if (!this.noMin && x < this.min) {
                return false;
            }
            return this.noMax || x <= this.max;
        }
        catch (Exception e) {
            return false;
        }
    }
}

