/*
 * Decompiled with CFR 0.152.
 */
package org.mentawai.rule;

import java.awt.Dimension;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.fileupload.FileItem;
import org.mentawai.core.Action;
import org.mentawai.core.Input;
import org.mentawai.rule.Rule;
import org.mentawai.util.ImageUtils;
import org.mentawai.util.RuntimeException;

public class ImageMinSizeRule
implements Rule {
    private static final Map<String, ImageMinSizeRule> cache = new HashMap<String, ImageMinSizeRule>();
    private Map<String, String> tokens = new HashMap<String, String>();
    private final int width;
    private final int height;

    public ImageMinSizeRule(int w) {
        this(w, -1);
    }

    private ImageMinSizeRule(int w, int h) {
        this.width = w;
        this.height = h;
        this.tokens.put("width", String.valueOf(w));
        if (h > 0) {
            this.tokens.put("height", String.valueOf(h));
        }
    }

    public static ImageMinSizeRule getInstance(int w) {
        return ImageMinSizeRule.getInstance(w, -1);
    }

    public static ImageMinSizeRule getInstance(int w, int h) {
        StringBuilder sb = new StringBuilder(16);
        sb.append(w).append('_').append(h);
        String pattern = sb.toString();
        ImageMinSizeRule fr = cache.get(pattern);
        if (fr != null) {
            return fr;
        }
        fr = new ImageMinSizeRule(w, h);
        cache.put(pattern, fr);
        return fr;
    }

    @Override
    public boolean check(String field, Action action) {
        Input input = action.getInput();
        Object value = input.getValue(field);
        if (value == null || value.toString().trim().equals("")) {
            return true;
        }
        if (value instanceof FileItem) {
            FileItem item = (FileItem)value;
            byte[] data = item.get();
            if (item.getSize() <= 0L || data == null || data.length <= 0) {
                throw new RuntimeException("Cannot find image file to validate: " + field);
            }
            Dimension d = ImageUtils.getSize(data);
            return !(d.getWidth() < (double)this.width) && !(d.getHeight() < (double)this.height);
        }
        throw new RuntimeException("Bad type for file upload: " + value.getClass());
    }

    @Override
    public Map<String, String> getTokens() {
        return this.tokens;
    }
}

