/*
 * Decompiled with CFR 0.152.
 */
package org.mentawai.rule;

import java.util.HashMap;
import java.util.Map;
import org.apache.commons.fileupload.FileItem;
import org.mentawai.core.Action;
import org.mentawai.core.Input;
import org.mentawai.rule.Rule;
import org.mentawai.util.RuntimeException;

public class FileSizeRule
implements Rule {
    private static final Map<String, FileSizeRule> cache = new HashMap<String, FileSizeRule>();
    private final int min;
    private final int max;
    private Map<String, String> tokens = new HashMap<String, String>();

    private FileSizeRule(int max) {
        this.min = 0;
        this.max = max;
        this.tokens.put("max", String.valueOf(max));
        this.tokens.put("min", String.valueOf(this.min));
    }

    private FileSizeRule(int min, int max) {
        this.min = min;
        this.max = max;
        this.tokens.put("max", String.valueOf(max));
        this.tokens.put("min", String.valueOf(min));
    }

    public static FileSizeRule getInstance(int min, int max) {
        StringBuilder sb = new StringBuilder(8);
        sb.append(min).append("_").append(max);
        String s = sb.toString();
        FileSizeRule fsr = cache.get(s);
        if (fsr != null) {
            return fsr;
        }
        fsr = new FileSizeRule(min, max);
        cache.put(s, fsr);
        return fsr;
    }

    public static FileSizeRule getInstance(int max) {
        return FileSizeRule.getInstance(0, max);
    }

    @Override
    public boolean check(String field, Action action) {
        Input input = action.getInput();
        Object value = input.getValue(field);
        if (value == null || value.toString().trim().equals("")) {
            return true;
        }
        if (value instanceof FileItem) {
            FileItem fi = (FileItem)value;
            long size = fi.getSize();
            return size >= (long)this.min && size <= (long)this.max;
        }
        throw new RuntimeException("Bad file type for upload: " + value.getClass());
    }

    @Override
    public Map<String, String> getTokens() {
        return this.tokens;
    }
}

