/*
 * Decompiled with CFR 0.152.
 */
package org.mentawai.rule;

import java.util.HashMap;
import java.util.Map;
import org.apache.commons.fileupload.FileItem;
import org.mentawai.core.Action;
import org.mentawai.core.Input;
import org.mentawai.rule.Rule;
import org.mentawai.util.RuntimeException;

public class FileRule
implements Rule {
    private static final Map<String, FileRule> cache = new HashMap<String, FileRule>();
    private String pattern;

    public FileRule(String pattern) {
        this.pattern = pattern;
    }

    public static FileRule getInstance(String pattern) {
        FileRule fr = cache.get(pattern);
        if (fr != null) {
            return fr;
        }
        fr = new FileRule(pattern);
        cache.put(pattern, fr);
        return fr;
    }

    @Override
    public boolean check(String field, Action action) {
        Input input = action.getInput();
        Object value = input.getValue(field);
        if (value == null || value.toString().trim().equals("")) {
            return true;
        }
        if (value instanceof FileItem) {
            FileItem item = (FileItem)value;
            return item.getContentType().matches(this.pattern);
        }
        throw new RuntimeException("Bad type for file upload: " + value.getClass());
    }

    @Override
    public Map<String, String> getTokens() {
        return null;
    }
}

