/*
 * Decompiled with CFR 0.152.
 */
package org.mentawai.rule;

import java.util.HashMap;
import java.util.Map;
import org.mentawai.rule.CrossRule;

public class EqualRule
extends CrossRule {
    private static final Map<String, EqualRule> cache = new HashMap<String, EqualRule>();
    private final String[] fields;

    public EqualRule(String field1, String field2) {
        this.fields = new String[]{field1, field2};
    }

    public static EqualRule getInstance(String field1, String field2) {
        StringBuilder sb = new StringBuilder(64);
        sb.append(field1).append('_').append(field2);
        String key = sb.toString();
        EqualRule er = cache.get(key);
        if (er != null) {
            return er;
        }
        er = new EqualRule(field1, field2);
        cache.put(key, er);
        return er;
    }

    @Override
    protected String[] getFieldsToValidate() {
        return this.fields;
    }

    @Override
    public boolean check(String[] values) {
        return values[0].equals(values[1]);
    }

    @Override
    public Map<String, String> getTokens() {
        return null;
    }
}

