/*
 * Decompiled with CFR 0.152.
 */
package org.mentawai.rule;

import java.util.HashMap;
import java.util.Map;
import org.mentawai.core.Action;
import org.mentawai.core.Input;
import org.mentawai.rule.Rule;

public class DependentRule
implements Rule {
    private static final Map<String, DependentRule> cache = new HashMap<String, DependentRule>();
    private final String field1;
    private final String field2;
    private final Map<String, String> tokens = new HashMap<String, String>();

    public DependentRule(String field1, String field2) {
        this.field1 = field1;
        this.field2 = field2;
        this.tokens.put("field1", field1);
        this.tokens.put("field2", field2);
    }

    public static DependentRule getInstance(String field1, String field2) {
        StringBuilder sb = new StringBuilder(64);
        sb.append(field1).append('_').append(field2);
        String key = sb.toString();
        DependentRule er = cache.get(key);
        if (er != null) {
            return er;
        }
        er = new DependentRule(field1, field2);
        cache.put(key, er);
        return er;
    }

    @Override
    public boolean check(String field, Action action) {
        boolean firstFieldPresent;
        Input input = action.getInput();
        String f1 = input.getString(this.field1);
        String f2 = input.getString(this.field2);
        boolean bl = firstFieldPresent = f1 != null && !f1.trim().equals("");
        if (firstFieldPresent) {
            boolean secondFieldPresent;
            boolean bl2 = secondFieldPresent = f2 != null && !f2.trim().equals("");
            if (!secondFieldPresent) {
                return false;
            }
        }
        return true;
    }

    @Override
    public Map<String, String> getTokens() {
        return this.tokens;
    }
}

