/*
 * Decompiled with CFR 0.152.
 */
package org.mentawai.rule;

import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import org.mentawai.rule.LocaleRule;

public class DateRule
extends LocaleRule {
    private static DateRule cache = null;
    private static final int STYLE = 3;
    private int style = 3;
    private SimpleDateFormat sdf = null;
    private Date min = null;
    private Date max = null;
    private ThreadLocal<Locale> loc = new ThreadLocal();

    public DateRule() {
    }

    public static DateRule getInstance() {
        if (cache != null) {
            return cache;
        }
        cache = new DateRule();
        return cache;
    }

    public DateRule(Date min, Date max) {
        this.min = min;
        this.max = max;
    }

    public DateRule(int style) {
        this.style = style;
    }

    public DateRule(int style, Date min, Date max) {
        this.style = style;
        this.min = min;
        this.max = max;
    }

    public DateRule(SimpleDateFormat sdf) {
        this.sdf = sdf;
    }

    public DateRule(String pattern) {
        this(new SimpleDateFormat(pattern));
    }

    public DateRule(SimpleDateFormat sdf, Date min, Date max) {
        this.sdf = sdf;
        this.min = min;
        this.max = max;
    }

    public DateRule(String pattern, Date min, Date max) {
        this(new SimpleDateFormat(pattern), min, max);
    }

    @Override
    public boolean check(String value, Locale locale) {
        if (this.min != null || this.max != null) {
            this.loc.set(locale);
        }
        DateFormat df = null;
        df = this.sdf != null ? this.sdf : DateFormat.getDateInstance(this.style, locale);
        df.setLenient(false);
        try {
            Date date = df.parse(value);
            if (this.min != null && date.getTime() < this.min.getTime()) {
                return false;
            }
            return this.max == null || date.getTime() <= this.max.getTime();
        }
        catch (ParseException e) {
            return false;
        }
    }

    @Override
    public Map<String, String> getTokens() {
        if (this.min != null || this.max != null) {
            DateFormat df = DateFormat.getDateInstance(this.style, this.loc.get());
            HashMap<String, String> map = new HashMap<String, String>();
            if (this.min != null) {
                map.put("min", df.format(this.min));
            }
            if (this.max != null) {
                map.put("max", df.format(this.max));
            }
            return map;
        }
        return null;
    }
}

