/*
 * Decompiled with CFR 0.152.
 */
package org.mentawai.rule;

import java.util.HashMap;
import java.util.Map;
import org.mentawai.rule.BasicRule;

public class ContainsRule
extends BasicRule {
    private String[] words;
    private static final Map<String, ContainsRule> cache = new HashMap<String, ContainsRule>();

    public ContainsRule(String ... words) {
        this.words = words;
    }

    private static String getKey(String ... words) {
        StringBuilder sb = new StringBuilder(64);
        for (String w : words) {
            sb.append(w).append("_");
        }
        sb.delete(sb.length() - 1, sb.length());
        return sb.toString();
    }

    public static ContainsRule getInstance(String ... words) {
        String key = ContainsRule.getKey(words);
        ContainsRule cr = cache.get(key);
        if (cr != null) {
            return cr;
        }
        cr = new ContainsRule(words);
        cache.put(key, cr);
        return cr;
    }

    @Override
    public Map<String, String> getTokens() {
        return null;
    }

    @Override
    public boolean check(String value) {
        value = value.toLowerCase().trim();
        for (String w : this.words) {
            if (value.equals(w = w.toLowerCase())) {
                return false;
            }
            if (value.startsWith(w + " ")) {
                return false;
            }
            if (value.endsWith(" " + w)) {
                return false;
            }
            if (!value.contains(" " + w + " ")) continue;
            return false;
        }
        return true;
    }
}

