/*
 * Decompiled with CFR 0.152.
 */
package org.mentawai.rule;

import java.util.regex.Pattern;
import org.mentawai.rule.BasicRule;

public class CPFRule
extends BasicRule {
    private static CPFRule cache = null;

    public static CPFRule getInstance() {
        if (cache != null) {
            return cache;
        }
        cache = new CPFRule();
        return cache;
    }

    @Override
    public boolean check(String value) {
        char[] digits = (value = value.replaceAll("\\D", "")).toCharArray();
        if (digits.length != 11) {
            return false;
        }
        if (Pattern.matches("^" + digits[0] + "{11}$", value)) {
            return false;
        }
        int j = 10;
        int n = 0;
        int i = 0;
        while (j >= 2) {
            n += Character.getNumericValue(digits[i++]) * j--;
        }
        if (Character.getNumericValue(digits[9]) != ((n %= 11) < 2 ? 0 : 11 - n)) {
            return false;
        }
        j = 11;
        n = 0;
        i = 0;
        while (j >= 2) {
            n += Character.getNumericValue(digits[i++]) * j--;
        }
        return Character.getNumericValue(digits[10]) == ((n %= 11) < 2 ? 0 : 11 - n);
    }
}

