/*
 * Decompiled with CFR 0.152.
 */
package org.mentawai.rule;

import java.util.regex.Pattern;
import org.mentawai.rule.BasicRule;

public class CNPJRule
extends BasicRule {
    private static CNPJRule cache = null;

    public static CNPJRule getInstance() {
        if (cache != null) {
            return cache;
        }
        cache = new CNPJRule();
        return cache;
    }

    @Override
    public boolean check(String value) {
        char[] digits = (value = value.replaceAll("\\D", "")).toCharArray();
        if (digits.length != 14) {
            return false;
        }
        if (Pattern.matches("^" + digits[0] + "{14}$", value)) {
            return false;
        }
        int[] factors = new int[]{6, 5, 4, 3, 2, 9, 8, 7, 6, 5, 4, 3, 2};
        int j = 0;
        int n = 0;
        while (j < 12) {
            n += Character.getNumericValue(digits[j++]) * factors[j];
        }
        if (Character.getNumericValue(digits[12]) != ((n %= 11) < 2 ? 0 : 11 - n)) {
            return false;
        }
        j = 0;
        n = 0;
        while (j <= 12) {
            n += Character.getNumericValue(digits[j]) * factors[j++];
        }
        return Character.getNumericValue(digits[13]) == ((n %= 11) < 2 ? 0 : 11 - n);
    }
}

